<?php
/**
 * TemplateMela
 * @copyright  Copyright (c) 2010 TemplateMela. (http://www.templatemela.com)
 * @license    http://www.templatemela.com/license/
 */
?><?php  // Reference:  http://codex.wordpress.org/Widgets_API
class TopBannersWidget extends WP_Widget
{
    function TopBannersWidget(){
		$widget_settings = array('description' => 'Top Banners Widget', 'classname' => 'widgets-banners');
		parent::WP_Widget(false,$name='TM - Top Banners Widget',$widget_settings);
    }
    function widget($args, $instance){
		extract($args);
		$is_template_path1 = isset($instance['is_template_path1']) ? $instance['is_template_path1'] : false;
		$is_template_path2 = isset($instance['is_template_path2']) ? $instance['is_template_path2'] : false;
        $window_target1 = isset($instance['window_target1']) ? $instance['window_target1'] : false;
		$window_target2 = isset($instance['window_target2']) ? $instance['window_target2'] : false;
		$imageSrc1 = empty($instance['imageSrc1']) ? '' : $instance['imageSrc1'];
		$imageSrc2 = empty($instance['imageSrc2']) ? '' : $instance['imageSrc2'];
		$linkURL1 = empty($instance['linkURL1']) ? '' : $instance['linkURL1'];
		$linkURL2 = empty($instance['linkURL2']) ? '' : $instance['linkURL2'];
		if($is_template_path1 == 1):
			$imageSrc1 = get_template_directory_uri() . '/images/banners/' . $imageSrc1; 
		endif;	
		if($is_template_path2 == 1):
			$imageSrc2 = get_template_directory_uri() . '/images/banners/' . $imageSrc2; 
		endif;
		echo $before_widget;
		 ?> 
			<div id="banner1" class="top_banner">				
				<span> <a href="<?php if($linkURL1 == ""): echo home_url( '/' ); else:?><?php echo $linkURL1; endif;?>" <?php if($window_target1 == true) echo 'target="_blank"'; ?>> <img src="<?php echo $imageSrc1; ?>" alt="" class="vv" /> </a> </span>
			
			</div>			   
			
			<div id="banner2" class="top_banner">
				<span> <a href="<?php if($linkURL2 == ""): echo home_url( '/' ); else:?><?php echo $linkURL2; endif;?>" <?php if($window_target2 == true) echo 'target="_blank"'; ?>> <img src="<?php echo $imageSrc2; ?>" alt="" class="vv" /> </a> </span>
			
			</div>
			
		<?php
		echo $after_widget;					
	}
    function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['window_target1'] = false;
		$instance['is_template_path1'] = false;
		
		$instance['window_target2'] = false;
		$instance['is_template_path2'] = false;
		
		if (isset($new_instance['window_target1'])) $instance['window_target1'] = true;
		if (isset($new_instance['window_target2'])) $instance['window_target2'] = true;
		
		if (isset($new_instance['is_template_path1'])) $instance['is_template_path1'] = true;
		if (isset($new_instance['is_template_path2'])) $instance['is_template_path2'] = true;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['imageSrc1'] = strip_tags($new_instance['imageSrc1']);
		$instance['imageSrc2'] = strip_tags($new_instance['imageSrc2']);
		
		$instance['linkURL1'] = strip_tags($new_instance['linkURL1']);
		$instance['linkURL2'] = strip_tags($new_instance['linkURL2']);		
		return $instance;
	}
    function form($instance){
		$instance = wp_parse_args( (array) $instance, array('title'=>'', 'window_target1' =>'', 'window_target2' =>'', 'imageSrc1'=>'', 
		'imageSrc2'=>'', 'is_template_path1'=>'', 'is_template_path2'=>'', 'linkURL1'=>'', 'linkURL2'=>'') );
		$imageSrc1 = esc_attr($instance['imageSrc1']);
		$imageSrc2 = esc_attr($instance['imageSrc2']);

		$window_target1 =  esc_attr($instance['window_target1']); 
		$window_target2 = esc_attr($instance['window_target2']); 	 			
		
		$is_template_path1 =  esc_attr($instance['is_template_path1']); 
		$is_template_path2 = esc_attr($instance['is_template_path2']); 	
		 	
		$linkURL1 = esc_attr($instance['linkURL1']);
		$linkURL2 = esc_attr($instance['linkURL2']);
		?>
		
		<p><label for="<?php echo $this->get_field_id('imageSrc1');?>">Banner1 URL:<br /></label>
			<input class="widefat" id="<?php echo $this->get_field_id('imageSrc1');?>" name="<?php echo $this->get_field_name('imageSrc1');?>" type="text" value="<?php echo $imageSrc1;?>" /><br />
			
			<input class="checkbox" type="checkbox" <?php checked($instance['is_template_path1'], true) ?> id="<?php echo $this->get_field_id('is_template_path1'); ?>" name="<?php echo $this->get_field_name('is_template_path1'); ?>" /><label for="<?php echo $this->get_field_id('is_template_path1'); ?>">Use Template Path for Image</label>
		</p>			
			
		<p>
		  <label for="<?php echo $this->get_field_id('linkURL1');?>">Link URL1:<br />
		  </label>
		  <input class="widefat" id="<?php echo $this->get_field_id('linkURL1');?>" name="<?php echo $this->get_field_name('linkURL1');?>" type="text" value="<?php echo $linkURL1;?>" />
		  <br />
		  <input class="checkbox" type="checkbox" <?php checked($instance['window_target1'], true) ?> id="<?php echo $this->get_field_id('window_target1'); ?>" name="<?php echo $this->get_field_name('window_target1'); ?>" />
		  <label for="<?php echo $this->get_field_id('window_target1'); ?>">Open Link In New Window</label>
		</p>
			
			
		
		
		
		<p><label for="<?php echo $this->get_field_id('imageSrc2');?>">Banner2 URL:<br /></label>
			<input class="widefat" id="<?php echo $this->get_field_id('imageSrc2');?>" name="<?php echo $this->get_field_name('imageSrc2');?>" type="text" value="<?php echo $imageSrc2;?>" /><br />
		<input class="checkbox" type="checkbox" <?php checked($instance['is_template_path2'], true) ?> id="<?php echo $this->get_field_id('is_template_path2'); ?>" name="<?php echo $this->get_field_name('is_template_path2'); ?>" /><label for="<?php echo $this->get_field_id('is_template_path2'); ?>">Use Template Path for Image</label>
		</p>	
			
			<p>
		  <label for="<?php echo $this->get_field_id('linkURL2');?>">Link URL2:<br />
		  </label>
		  <input class="widefat" id="<?php echo $this->get_field_id('linkURL2');?>" name="<?php echo $this->get_field_name('linkURL2');?>" type="text" value="<?php echo $linkURL2;?>" />
		  <br />
		  
		   <input class="checkbox" type="checkbox" <?php checked($instance['window_target2'], true) ?> id="<?php echo $this->get_field_id('window_target2'); ?>" name="<?php echo $this->get_field_name('window_target2'); ?>" />
		  <label for="<?php echo $this->get_field_id('window_target2'); ?>">Open Link In New Window</label>
		</p>
		
		<?php
	}
}
add_action('widgets_init', create_function('', 'return register_widget("TopBannersWidget");'));
// end AboutWidget
?>