<?php 

// Start Jigoshop //
if (!function_exists('jigoshop_output_content_wrapper')) {
	function jigoshop_output_content_wrapper() {
		echo '<div class="shop-page"><div id="primary" class="site-content">'.breadcrumbs().'<div id="content" role="main">';		
	}
}
if (!function_exists('jigoshop_output_content_wrapper_end')) {
	function jigoshop_output_content_wrapper_end() {
		echo '</div></div></div>';
	}
}
/**
 * Products Loop
 **/
if (!function_exists('jigoshop_template_loop_add_to_cart')) {
	function jigoshop_template_loop_add_to_cart( $post, $_product ) {
	global $wpdb;
	
	
		
		$count = $wpdb->get_var("
                SELECT COUNT(meta_value) FROM $wpdb->commentmeta
                LEFT JOIN $wpdb->comments ON $wpdb->commentmeta.comment_id = $wpdb->comments.comment_ID
                WHERE meta_key = 'rating'
                AND comment_post_ID = $post->ID
                AND meta_value > 0
        ");
        
        $rating = $wpdb->get_var("
                SELECT SUM(meta_value) FROM $wpdb->commentmeta
                LEFT JOIN $wpdb->comments ON $wpdb->commentmeta.comment_id = $wpdb->comments.comment_ID
                WHERE meta_key = 'rating'
                AND comment_post_ID = $post->ID
        "); 
		do_action('jigoshop_before_add_to_cart_button');

		// do not show "add to cart" button if product's price isn't announced
		if ( $_product->get_price() === '' AND ! ($_product->is_type(array('variable', 'grouped', 'external'))) ) return;

		if ( $_product->is_in_stock() OR $_product->is_type('external') ) {
			$button_type = Jigoshop_Base::get_options()->get_option('jigoshop_catalog_product_button');
			if ( $button_type === false ) $button_type = 'add';
			if ( $_product->is_type(array('variable', 'grouped')) ) {
				if ( $button_type != 'none' ) {
					if ( $button_type == 'view' ) {
						$output = '<a href="'.esc_url(get_permalink($_product->id)).'" class="button">'.__('View Product', 'jigoshop').'</a>';
					} else {
						$output = '<a href="'.esc_url(get_permalink($_product->id)).'" class="button">'._x('Select', 'verb', 'jigoshop').'</a>';
					}
				} else {
					$output = '';
				}
			} else if ( $_product->is_type('external') ) {
				if ( $button_type != 'none' ) {
					if ( $button_type == 'view' ) {
						$output = '<a href="'.esc_url(get_permalink($_product->id)).'" class="button">'.__('View Product', 'jigoshop').'</a>';
					} else {
						$output = '<a href="'.esc_url(get_post_meta( $_product->id, 'external_url', true )).'" class="button" rel="nofollow">'.__('Buy product', 'jigoshop').'</a>';
					}
				} else {
					$output = '';
				}
			} else if ( $button_type == 'add' ) {
				$output = "<div class='block_hover'>";
				if ( $count>0 ) :                
					$average = number_format($rating / $count, 2);				
					$star_size = apply_filters('jigoshop_star_rating_size_recent_reviews', 16);  
					$output .= "<div class='star-rating' title='{$rating}'>
							<span style='width:".($rating*$star_size)."px;'>{$rating} ".__( 'out of 5', 'jigoshop' )."</span>
						</div>";
        		endif;
				$output .= '<a href="'.esc_url($_product->add_to_cart_url()).'" class="button" rel="nofollow">'.__('Add to cart', 'jigoshop').'</a>';
				$output .= "</div>";
			} else if ( $button_type == 'view' ) {
				$output = "<div class='block_hover'>";
				if ( $count>0 ) :                
					$average = number_format($rating / $count, 2);				
					$star_size = apply_filters('jigoshop_star_rating_size_recent_reviews', 16);  
					$output .= "<div class='star-rating' title='{$rating}'>
							<span style='width:".($rating*$star_size)."px;'>{$rating} ".__( 'out of 5', 'jigoshop' )."</span>
						</div>";
        		endif;
				$output = '<a href="'.esc_url(get_permalink($_product->id)).'" class="button">'.__('View Product', 'jigoshop').'</a>';
				echo "</div>";
			} else {
				$output = '';
			}
		} else if ( ($_product->is_type(array('grouped')) ) ) {
			$output = '';
		} else {	 
			$output = '<span class="nostock">'.__('Out of Stock', 'jigoshop').'</span>';
		}

		echo apply_filters( 'jigoshop_loop_add_to_cart_output', $output, $post, $_product );

		do_action('jigoshop_after_add_to_cart_button');

	}
}
if (!function_exists('jigoshop_template_loop_product_thumbnail')) {
	function jigoshop_template_loop_product_thumbnail( $post, $_product ) {
		$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); 
		$product_image_width = get_option('jigoshop_shop_small_w');
		$product_image_height = get_option('jigoshop_shop_small_h'); 	
		?>		
		<div class='image-block'>	
			<?php if ($image[0]) : ?>
				<?php print_images_thumb($image[0], get_the_title(get_the_ID()) ,$product_image_width,$product_image_height,'left'); ?>		
			<?php else: ?>
				<img src="<?php echo get_template_directory_uri() . '/images/placeholder.png' ?>" alt="Image not found" height="<?php echo $product_image_height; ?>" width="<?php echo $product_image_width; ?>"/>
			<?php endif; ?>	
		</div>
		<?php $shorttitle = substr($post->post_title,0,20); ?>
		<div class="product_title"><?php echo $shorttitle; if (strlen($shorttitle) >= 20){ echo '...'; } ?></div>
		<?php			
		/*$availability = $_product->get_availability();
		if ( $availability <> '' ) {
			?>
			<div class="product_stock"><?php echo $availability['availability']; ?></div>
			<?php
		} */
	}
}
/**
 * Before Single Products Summary Div
 **/
if (!function_exists('jigoshop_show_product_images')) {
	function jigoshop_show_product_images() {

		global $_product, $post;

		echo '<div class="images">';

		do_action( 'jigoshop_before_single_product_summary_thumbnails', $post, $_product );

		$thumb_id = 0;
		$height = 300;
		$width = 300;
		if (has_post_thumbnail()) :
			$thumb_id = get_post_thumbnail_id();
			// since there are now user settings for sizes, shouldn't need filters -JAP-
			//$large_thumbnail_size = apply_filters('single_product_large_thumbnail_size', 'shop_large');
			$large_thumbnail_size = jigoshop_get_image_size( 'shop_large' );
			$image_classes = apply_filters( 'jigoshop_product_image_classes', array(), $_product );
			array_unshift( $image_classes, 'zoom' );
			$image_classes = implode( ' ', $image_classes );
			
			$args = array( 'post_type' => 'attachment', 'post_mime_type' => 'image', 'numberposts' => -1, 'post_status' => null, 'post_parent' => $post->ID, 'orderby' => 'menu_order', 'order' => 'asc', 'fields' => 'ids' );
			$attachments = get_posts($args);
			$attachment_count = count( $attachments );
			if ( $attachment_count > 1 ) {
				$gallery = '[product-gallery]';
			} else {
				$gallery = '';
			}
			
			echo '<a id="imageBoxa" href="'.wp_get_attachment_url($thumb_id).'" data-lightbox="example-set" rel="gal">';
			echo '<div class="imageBoxouter">';
			echo '<div id="imageBox">'; ?>
				<?php the_post_thumbnail($large_thumbnail_size); ?>
			<?php 
			echo '</div>';
			echo '</div>';
			echo '</a>';
		else :
			echo jigoshop_get_image_placeholder( 'shop_large' );
		endif;

		do_action('jigoshop_product_thumbnails');

		echo '</div>';

	}
}
/**
 * Sidebar
 **/
if (!function_exists('jigoshop_get_sidebar')) {
	function jigoshop_get_sidebar() { ?>	
		<!--- Start Templatemela Laypout Settings --->	
		<?php if (get_option('tmoption_layout')=='3' || get_option('tmoption_layout')=='4' || get_option('tmoption_layout')=='5' ) { ?>	
			<?php get_sidebar('secondary'); ?>
		<?php } ?>
		<!--- End Templatemela Laypout Settings --->
		<div id="tertiary" class="widget-area jigoshop_secondary" role="complementary">	
			<?php templatemela_get_widget('sidebar-3');	 ?>
		</div>
	<?php }
}

if (!function_exists('jigoshop_show_product_thumbnails')) {
	function jigoshop_show_product_thumbnails() {

		global $_product, $post;	
		
		$postContent = $post->post_content;
		$searchPattern = '~<img [^\>]*\ />~';
		
		// Run preg_match_all to grab all the images and save the results in $aPics
		preg_match_all( $searchPattern, $postContent, $aPics );
		
		// Check to see if we have at least 1 image
		$thumbs = count($aPics[0]);
		$thumbs_height = 58;
		$thumbs_width = 58;
		if ( $thumbs > 0 ) : ?>
			<div id="thumblist" class="porduct_thumbs products_block">
				<div class="customNavigation">
					<a class="btn prev">&nbsp;</a>
					<a class="btn next">&nbsp;</a>
				</div>	
				<ul id="porduct_thumbs">
					<?php for ( $i=0; $i < $thumbs ; $i++ ) { 
					$img_full = $aPics[0][$i];
					preg_match('/<img\s.*?\bsrc="(.*?)".*?>/si', $img_full, $matches);
					$largeimage = $matches[1];					
					?>
						<li class="single-thumb">
							<a href='<?php echo $largeimage; ?>' data-lightbox="example-set">
							
							<?php if ($matches[1]) : ?>
								<?php print_images_thumb($matches[1], get_the_title(get_the_ID()) ,$thumbs_height,$thumbs_height,'left'); ?>		
							<?php else: ?>
								<img src="<?php echo get_template_directory_uri() . '/images/placeholder.png' ?>" alt="Image not found" height="<?php echo $thumbs_height; ?>" width="<?php echo $thumbs_height; ?>"/>
							<?php endif; ?>	
							</a>
						</li>		  			
					<?php }; ?>
				</ul>
				<span class="thumblist_default_width" style="display:none; visibility:hidden"></span>	
			</div>
			
		<?php endif; ?>
		
	<?php }
}
if (!function_exists('jigoshop_product_description_panel')) {
	function jigoshop_product_description_panel() {
		$content = get_the_content();
		$content = apply_filters( 'the_content', $content );
		$content = str_replace( ']]>', ']]&gt;', $content );
		$content = apply_filters( 'jigoshop_single_product_content', $content );
		if ( $content <> '' ) {
			echo '<div class="panel" id="tab-description">';
			$heading = apply_filters('jigoshop_product_description_heading', '');
			if ( ! empty( $heading )) {
				echo '<h2>' . $heading . '</h2>';
			}
			echo strip_images($content);
			echo '</div>';
		}
	}
}
if (!function_exists('jigoshop_product_attributes_panel')) {
	function jigoshop_product_attributes_panel() {
		global $_product;
		$content = apply_filters( 'jigoshop_single_product_attributes', $_product->list_attributes() );
		if ( $content <> '' ) {
			echo '<div class="panel" id="tab-attributes">';
			$heading = apply_filters('jigoshop_product_attributes_heading', '');
			if ( ! empty( $heading )) {
				echo '<h2>' . $heading . '</h2>';
			}
			echo strip_images($content);
			echo '</div>';
		}
	}
}
if (!function_exists('jigoshop_template_single_meta')) {
	function jigoshop_template_single_meta( $post, $_product ) {

        $jigoshop_options = Jigoshop_Base::get_options();
		echo '<div class="product_meta">';
		if ($jigoshop_options->get_option('jigoshop_enable_sku')=='yes' && !empty($_product->sku)) :
			echo '<div class="sku">'.__('SKU','jigoshop').': ' . $_product->sku . '</div>';
		endif;

		echo $_product->get_categories( ', ', ' <div class="posted_in">' . __( 'Categories: ', 'jigoshop' ) . '', '.</div>');
		echo $_product->get_tags( ', ', ' <div class="tagged_as">' . __( 'Tags: ', 'jigoshop' ) . '', '.</div>');
		echo '</div>';

	}
}
/**
 * Pagination
 **/
if (!function_exists('jigoshop_pagination')) {
	function jigoshop_pagination() {

		global $wp_query;
		if (  $wp_query->max_num_pages > 1 ) : 
			if(get_option('tmoption_navigation_option')=='2') : ?>
				<!-- Start #nav-below -->
				<div id="nav-below" class="navigation">
					<?php get_pagination(); ?>
				</div>
				<!-- End #nav-below -->
			<?php endif; ?>
			<?php if(get_option('tmoption_navigation_option')=='1') : ?>
				<div class="custom-pagination">			
					<span class="nav-previous"><?php previous_posts_link('&laquo; Previous') ?></span>
					<span class="nav-next"><?php next_posts_link('Next &raquo;') ?></span>
				</div>
			<?php endif; ?>
		<?php endif; 

	}
}


/**
  * Jigoshop Related Products
  **/
if (!function_exists('jigoshop_output_related_products')) {
	if (!function_exists('jigoshop_output_related_products')) {
		function jigoshop_output_related_products() {
			$jigoshop_options = Jigoshop_Base::get_options();
			if ($jigoshop_options->get_option ('jigoshop_enable_related_products') != 'no')
				// 2 Related Products in 2 columns
				jigoshop_related_products( 10, 10 );
		}
	}
}
// End Jigoshop //
?>
