<?php
/*
Plugin Name: Interactive World Maps (shared on wplocker.com)
Plugin URI: http://www.cmoreira.net/interactive-world-maps-demo
Description: Create interactive maps and put them anywere on your website, including posts, pages and widgets. You can set the view to the whole world, a continent, a specific country or a US state. You can color full regions or just create markers on specific locations that will have information on hover and can also have actions on click. This plugin uses the Google GeoChart API to render the maps.
Author: cmoreira
Version: 1.3.8
Author URI: http://www.cmoreira.net
*/

//Last Modified: March 13 2013


//Instalation Code
//Creates Table in the database

global $wpdb;
$table_name_imap = $wpdb->prefix . "i_world_map";
$i_world_map_db_version = "2.1";

function i_world_map_install() {
    global $wpdb;
    global $i_world_map_db_version;	
    global $table_name_imap;
	
	if (!empty ($wpdb->charset))
        $charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
    if (!empty ($wpdb->collate))
        $charset_collate .= " COLLATE {$wpdb->collate}";
	
	
	$sql = "CREATE TABLE " . $table_name_imap . " (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `name` varchar(255) DEFAULT NULL,
					  `description` longtext,
					  `use_defaults` int(11) DEFAULT NULL,					  
					  `bg_color` varchar(100) DEFAULT NULL,
					  `border_color` varchar(100) DEFAULT NULL,
					  `border_stroke` varchar(100) DEFAULT NULL,
					  `ina_color` varchar(100) DEFAULT NULL,
					  `act_color` varchar(100) DEFAULT NULL,
					  `marker_size` int(11) DEFAULT NULL,	
					  `width` varchar(100) DEFAULT NULL,
					  `height` varchar(100) DEFAULT NULL,
					  `aspect_ratio` int(11) DEFAULT NULL,
					  `interactive` int(11) DEFAULT '1',
					  `showtooltip` int(11) DEFAULT '1',
					  `region` varchar(100) DEFAULT NULL,
					  `display_mode` varchar(100) DEFAULT NULL,
					  `map_action` varchar(100) DEFAULT NULL,
					  `places` LONGTEXT NULL DEFAULT NULL,
					  `custom_action` LONGTEXT NULL DEFAULT NULL,
					  `custom_css` LONGTEXT NULL DEFAULT NULL,
					  `created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
					   PRIMARY KEY (`id`)
			) {$charset_collate};";



			if ($wpdb->get_var("show tables like '$table_name_imap'") != $table_name_imap) {
				
				require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
				dbDelta($sql);
				add_option("i_world_map_db_version", $i_world_map_db_version);
			 }

			 if (get_site_option('i_world_map_db_version') != $i_world_map_db_version) {

				require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
      				dbDelta($sql);
      				update_option( "i_world_map_db_version", $i_world_map_db_version );

			}


}

//Unistall Code
function i_world_map_uninstall() {
    $data = get_option('i_world_map');
    $data['first_time'] = "not";
    $data = update_option('i_world_map', $data);
}

//Install Unistall Hook
register_activation_hook(__FILE__, 'i_world_map_install');
register_deactivation_hook(__FILE__, 'i_world_map_uninstall');


//update codes

function i_world_map_update_db_check() {
global $i_world_map_db_version;
       if (get_site_option('i_world_map_db_version') != $i_world_map_db_version) {
        i_world_map_install();
    }
}

add_action('plugins_loaded', 'i_world_map_update_db_check');


//Run the Shortcode to Build Interactive Map
function shortcode_i_world_map( $atts ) {	
	$id = $atts['id'];
	return build_i_world_map_exec($id,'shortcode');	
}

//run php comand to Build Interactive Map
function build_i_world_map($id) {
		
	build_i_world_map_exec($id,'php');
}

//Add shortcode functionality
add_shortcode('show-map', 'shortcode_i_world_map');
add_filter('widget_text', 'do_shortcode');
add_filter( 'the_excerpt', 'do_shortcode');

//Main Function to build the map
function build_i_world_map_exec($id,$type) {
		
	$id = $id;
	
	global $wpdb;
	global $table_name_imap;
	$mapdata = $wpdb->get_row("SELECT * FROM $table_name_imap WHERE id = $id", ARRAY_A);
	$input = str_replace(array("\r\n", "\r", "\n"), ' ', addslashes($mapdata['places']));
	$places = explode(";", $input,-1);
	
	add_action('wp_enqueue_scripts', 'i_world_map_scripts');
		
	echo '<script type="text/javascript">';
	echo 'var ivalue_'.$mapdata['id'].' = new Array();';
	echo "google.load('visualization', '1', {packages: ['geochart']});";
  		
		//If not Markers
  		if($mapdata['display_mode']!="markers02") {
  
    		
		echo "function drawVisualization() {
							var data = new google.visualization.DataTable();
							data.addColumn('string', 'Country'); // Implicit domain label col.
							data.addColumn('number', 'Value'); // Implicit series 1 data col.
							data.addColumn({type:'string', role:'tooltip'}); 
							";
			
			$i = 1;
			foreach ($places as $place) { 
			$arr = explode(",",$place);
			
			$ttit  = $arr[1];
			$ttool = $arr[2];
			
			$ofinal = array(",", ";");
			$oreplace   = array("&#44", "&#59");
					
			$ttitle = str_replace($oreplace,$ofinal , $ttit);
			$ttooltip = str_replace($oreplace,$ofinal , $ttool);
			
				echo 'data.addRows([[{v:"'.trim($arr[0]).'",f:"'.trim($ttitle).'"},'.$i.',"'.$ttooltip.'"]]);
				';				
				$i++;
				
					$index = $arr[0];
					//Adding the Action Values
					$oaction  = trim($arr[3]);
					$ofinal = array(",", ";");
					$oreplace   = array("&#44", "&#59");		
					$formatedactionv = str_replace($oreplace,$ofinal , $oaction);		
					echo "ivalue_".$mapdata['id']."['".trim($index)."'] = '".$formatedactionv."';
					";
				} }

	//if Markers
	else {
			
		echo "function drawVisualization() {
							var data = new google.visualization.DataTable();
							
							data.addColumn('number', 'Lat'); // Latitude Value
							data.addColumn('number', 'Lon'); // Longitude Value
							data.addColumn('string', 'Country'); // 
							data.addColumn('number', 'Value'); // 
							data.addColumn({type:'string', role:'tooltip'}); 
							";
			$i = 1;
			foreach ($places as $place) { 
			$arr = explode(",",$place);		
				
			$trim = trim($arr[0]);
			$latlon = explode(" ",$trim);
			$lat = (float)$latlon[0];
			$lon = (float)$latlon[1];		
			
			$ttit  = $arr[1];
			$ttool = $arr[2];
			
			$ofinal = array(",", ";");
			$oreplace   = array("&#44", "&#59");
					
			$ttitle = str_replace($oreplace,$ofinal , $ttit);
			$ttooltip = str_replace($oreplace,$ofinal , $ttool);	
					
			echo 'data.addRows([['.$lat.','.$lon.',"'.$ttitle.'",'.$i.',"'.$ttooltip.'"]]);
			';	
			$i++;
			
			$index = $lat;
			//Adding the Action Values
			$oaction  = trim($arr[3]);
			$ofinal = array(",", ";");
			$oreplace   = array("&#44", "&#59");		
			$formatedactionv = str_replace($oreplace,$ofinal , $oaction);		
			echo "ivalue_".$mapdata['id']."['".trim($index)."'] = '".$formatedactionv."'; 
			";
	
			} 
	}

	$count = count($places);
	if ($count == 0) { $count = 1; } 
	$colors ="";
	foreach ($places as $place) { 
		$arr = explode(",",$place);
		$colors .= "'".trim($arr[4])."',";		
		 } 
	
	if($mapdata['use_defaults'] == 1) {
		
	$options = get_option('i-world-map-settings');
	
		$bg_color = $options['default_bg_color'];
		$border_color = $options['default_border_color'];
		$border_stroke = $options['default_border_stroke'];
		$ina_color = $options['default_ina_color'];
		$act_color = $options['default_act_color'];
		$marker_size = $options['default_marker_size'];
		$width = $options['default_width'];
		$height = $options['default_height'];
		$aspect_ratio = $options['default_aspect_ratio'];
				
		
	} else {
		$bg_color = $mapdata['bg_color'];
		$border_color = $mapdata['border_color'];
		$border_stroke = $mapdata['border_stroke'];
		$ina_color = $mapdata['ina_color'];
		$act_color = $mapdata['act_color'];
		$marker_size = $mapdata['marker_size'];
		$width = $mapdata['width'];
		$height = $mapdata['height'];
		$aspect_ratio = $mapdata['aspect_ratio'];
		
		
	}
	
		$interactive = $mapdata['interactive'];
		$tooltipt = $mapdata['showtooltip'];
	
		$diplaym = "regions";
		if($mapdata['display_mode']!="regions") {
			$diplaym = "markers";
		}
		
		if($interactive == 0) {
			$interactive = "false";
		}
		else {
			$interactive = "true";
		}
		
		if($tooltipt == 0) {
			$tooltipt = "none";
		}
		else {
			$tooltipt = "focus";
		}
		
				
		$display_mode = $diplaym;
		$areashow = explode(",", $mapdata['region']);
		$region = $areashow[0]; 
		$resolution = $areashow[1];
		$map_action = $mapdata['map_action'];
		$custom_action = $mapdata['custom_action'];
		//remove last comma from colors array
		$colors = substr($colors, 0, -1);
			
	echo "var options = {   ";
		   
        echo "colorAxis: {minValue: 1, maxValue:".$count.",  colors: [".$colors."]},
		legend: 'none',	
		backgroundColor: {fill:'".$bg_color."',stroke:'".$border_color."' ,strokeWidth:".$border_stroke." },		
		datalessRegionColor: '".$ina_color."',
		displayMode: '".$display_mode."', 
		sizeAxis: {minValue: 1, maxValue:".$count.",minSize:".$marker_size.",  maxSize: ".$marker_size."},
		enableRegionInteractivity: '".$interactive."',
		resolution: '".$resolution."',
		region:'".$region."',";
		if($aspect_ratio==0) { 
		echo "keepAspectRatio: false,";
		} 
		echo "width:'".$width."',
		height:'".$height."',
		tooltip: {textStyle: {color: '#555555'}, trigger:'".$tooltipt."'}	
			
      };";
	    
	
      echo "var geochart = new google.visualization.GeoChart(
          document.getElementById('map_canvas_".$id."'));";
		  
		$beforediv="";  
		$afterdiv ="";
		if($map_action != "none" || $map_action!='null' ) { 
			i_world_map_run_action($map_action,$id,$custom_action);
 	
		  	if($map_action =='i_map_action_content_below') {
				$afterdiv ="<div id='imap".$id."message'></div>";
				}
			if($map_action =='i_map_action_content_above') {
				$beforediv ="<div id='imap".$id."message'></div>";
				}

		}
      echo "geochart.draw(data, options);
    }
    google.setOnLoadCallback(drawVisualization);
  </script>";

	

	if($type == "shortcode") {
		return $beforediv."<div id='map_canvas'><div id='map_canvas_".$id."' class='i_world_map'></div></div>".$afterdiv;
	} else {
		echo $beforediv."<div id='map_canvas'><div id='map_canvas_".$id."' class='i_world_map'></div></div>".$afterdiv;
	}
}

//ADMIN MENU

// create custom plugin settings menu

add_action('admin_menu', 'i_world_map_create_menu');



function i_world_map_create_menu() {
	
	if (current_user_can('manage_options')) {
	// Add the top-level admin menu
    $page_title = 'Interactive World Maps';
    $menu_title = 'i World Maps';
	
	//You can change the capibility here
    $capability = 'manage_options';
	
    $menu_slug = 'i_world_map_menu';
    $function = 'i_world_map_manage';
    $mainp = add_menu_page($page_title, $menu_title, $capability, $menu_slug, $function,plugins_url('interactive-world-maps/imgs/iwm-icon-small.png'),'61.15');
	
	//sub menu main 
	$sub_menu_title = 'Manage Maps';
    $managep = add_submenu_page($menu_slug, $page_title, $sub_menu_title, $capability, $menu_slug, $function);
	
	$submenu_page_title = 'Add New';
    $submenu_title = 'Add New Map';
    $submenu_slug = 'iwm_add';
    $submenu_function = 'i_world_map_add_new';
    $addp = add_submenu_page($menu_slug, $submenu_page_title, $submenu_title, $capability, $submenu_slug, $submenu_function);
	
	
	$submenu_page_title = 'Default Settings';
    $submenu_title = 'Default Settings';
    $submenu_slug = 'iwm_settings';
    $submenu_function = 'i_world_map_settings_page';
    $defaultp = add_submenu_page($menu_slug, $submenu_page_title, $submenu_title, $capability, $submenu_slug, $submenu_function);

			
	//call register settings function
	add_action( 'admin_init', 'register_i_world_map_settings' );
	add_action($addp, 'i_world_map_includes_add');
	add_action($defaultp, 'i_world_map_includes_def');
	}
}

function i_world_map_includes_def() {
    /** Register */
    wp_register_style('i_world_map_css', plugins_url('style.css', __FILE__), array(), '1.0.0', 'all');
	wp_register_script( 'jsapi', 'http://www.google.com/jsapi',array(),false,false);
	wp_register_script( 'jsgeo', 'http://maps.google.com/maps/api/js?sensor=false',array(),false,false);
    wp_register_script( 'jscolor', plugins_url( 'js/jscolor.js' , __FILE__ ) );
	wp_register_script( 'jsadmin', plugins_url( 'js/admin.js' , __FILE__ ) );	 
	wp_register_script( 'jssettings', plugins_url( 'js/settings.js' , __FILE__ ) );
	
	 
    /** Enqueue */
    wp_enqueue_style('i_world_map_css');
	wp_enqueue_script( 'jsapi' );
	wp_enqueue_script( 'jsgeo' );
	wp_enqueue_script( 'jscolor' );
	wp_enqueue_script( 'jsadmin' );
	wp_enqueue_script( 'jssettings' );
 
   }
   
function i_world_map_includes_add() {
    /** Register */
    wp_register_style('i_world_map_css', plugins_url('style.css', __FILE__), array(), '1.0.0', 'all');
	wp_register_script( 'jsapi', 'http://www.google.com/jsapi',array(),false,false);
    wp_register_script( 'jscolor', plugins_url( 'js/jscolor.js' , __FILE__ ) );
	wp_register_script( 'jsadmin', plugins_url( 'js/admin.js' , __FILE__ ) );	 
	
	 
    /** Enqueue */
	wp_enqueue_script('jsapi');	
    wp_enqueue_style('i_world_map_css');
	wp_enqueue_script('jscolor');
	wp_enqueue_script('jsadmin');
	 
   }

function i_world_map_scripts() {
    wp_deregister_script( 'jsapifull' );
   wp_register_script( 'jsapifull', 'http://www.google.com/jsapi',array(),false,false);
    wp_enqueue_script( 'jsapifull' );
}    
 
add_action('wp_enqueue_scripts', 'i_world_map_scripts');
 

//Manage Maps Screen
function i_world_map_manage() { 
	$alert = "";
	
	if(isset($_GET['action']) && ($_GET['action'] == 'delete')) {
	delete_i_world_map($_GET['map']);
	$alert = "Map Deleted";
	}
	
    $iwmaptable = new i_world_map_manage_table();   
    $iwmaptable->prepare_items();
    
    ?>
    <div class="wrap">
        
         <h2><img src="<?php echo plugins_url('interactive-world-maps/imgs/iwm-icon.png'); ?>" /> Manage Maps</h2>
         <?php if($alert!="") {i_world_map_message($alert);} ?> 
       
        <form id="movies-filter" method="get">
            
            <input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
            
            <?php $iwmaptable->display() ?>
        </form>
        
        <br />
        <br />
        <a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=iwm_add" class="button-primary">Add New Map</a>
        <br />
        <br />
        
    </div>
    <?php
}

//Add new map and edit screen
function i_world_map_add_new() { 

	if(isset($_POST['action'])) {
		global $wpdb;
		$name = stripslashes ($_POST['name']);
		$description = stripslashes ($_POST['description']);
		$use_defaults = stripslashes ($_POST['use_defaults']);
		$border_color = stripslashes ($_POST['border_color']);
		$border_stroke = stripslashes ($_POST['border_stroke']);
		$bg_color = stripslashes ($_POST['bg_color']);
		$ina_color = stripslashes ($_POST['ina_color']);
		$act_color = stripslashes ($_POST['act_color']);
		$marker_size = stripslashes ($_POST['marker_size']);
		$width = stripslashes ($_POST['width']);
		$height = stripslashes ($_POST['height']);
		$aspect_ratio = stripslashes ($_POST['aspect_ratio']);
		$interactive = stripslashes ($_POST['interactive']);
		$tooltipt = stripslashes ($_POST['tooltipt']);
		$region = stripslashes ($_POST['region']);
		$display_mode = stripslashes ($_POST['display_mode']);
		$places = stripslashes ($_POST['places']);
		$map_action = stripslashes ($_POST['map_action']);
		$custom_action = stripslashes ($_POST['custom_action']);
		global $table_name_imap;
		
		if ($_POST['action'] == 'addmap') {
		
			if($wpdb->insert( 
			$table_name_imap, 
			array( 
				'name' => $name, 
				'description' => $description, 
				'use_defaults' => $use_defaults,
				'bg_color' => $bg_color,
				'border_color' => $border_color,
				'border_stroke' => $border_stroke,
				'ina_color' => $ina_color,
				'act_color' => $act_color,
				'marker_size' => $marker_size,
				'width' => $width,
				'height' => $height,
				'aspect_ratio' => $aspect_ratio,
				'interactive' => $interactive,
				'showtooltip' => $tooltipt,
				'region' => $region,
				'display_mode' => $display_mode,
				'custom_action' => $custom_action,
				'map_action' => $map_action,
				'places' => $places
			)) == true) {
				$alert = "New Map Added";
			} else {
			$alert = "ERROR: Map NOT Added";	
			}
					
			i_world_map_build_form('edit-map',$wpdb->insert_id,$alert);			
			}
		
		if($_POST['action'] == 'editmap') {
		
			$id = $_POST['id'];
					
			if($wpdb->update( 
			$table_name_imap, 
			array( 
				'name' => $name, 
				'description' => $description, 
				'use_defaults' => $use_defaults,
				'bg_color' => $bg_color,
				'border_color' => $border_color,
				'border_stroke' => $border_stroke,
				'ina_color' => $ina_color,
				'act_color' => $act_color,
				'marker_size' => $marker_size,
				'width' => $width,
				'height' => $height,
				'aspect_ratio' => $aspect_ratio,
				'interactive' => $interactive,
				'showtooltip' => $tooltipt,
				'region' => $region,
				'display_mode' => $display_mode,
				'map_action' => $map_action,
				'custom_action' => $custom_action,
				'places' => $places
			),array( 'id' => $id )) == true) {
			$alert = "Map Updated";
			} else {
			$alert = "Map NOT Updated";	
			}
				
		}
	}
	//special if condition to run after the new map is created
	if(isset($_POST['action']) && ($_POST['action'] == 'editmap') && (!isset($_GET['action'])) ) {
		$id = $_POST['id'];
		i_world_map_build_form('edit-map',$id,$alert);
	}
	

	if(isset($_GET['action']) && ($_GET['action'] == 'edit')) {
   		if(!isset($_POST)) { $alert = ""; } 
		if(!isset($id)) { $id = $_GET['map']; }
		
		i_world_map_build_form('edit-map',$id,$alert);
  		
			
	 } 
	 
	 if(!isset($_GET['action']) && (!isset($_POST['action']))) {
	 
		i_world_map_build_form('post-map',0,$alert);
 }
}

function i_world_map_build_form($type,$id,$alert) { 

if($type == 'post-map') {
	
	$message = "Fill out the form and follow the instructions to create your Interactive Map";
	$formname = "addimap";
	settings_fields( 'i-world-map-plugin-settings' );
	$title = " Add New Interactive Map";
	$options = get_option('i-world-map-settings');
	$name = "";
	$description = "";
	$use_defaults = 1;
	$border_color = $options['default_border_color'];
	$border_stroke =  $options['default_border_stroke'];
	$bg_color = $options['default_bg_color'];
	$ina_color = $options['default_ina_color'];
	$act_color = $options['default_act_color'];
	$marker_size = $options['default_marker_size'];
	$width = $options['default_width'];
	$height = $options['default_height'];
	$aspect_ratio = $options['default_aspect_ratio'];
	$interactive = $options['default_interactive'];
	$tooltipt = $options['default_showtooltip'];
	$region = $options['default_region'];
	$display_mode = $options['default_display_mode'];
	$places = "";
	$map_action = 'none';
	$custom_action = '';
	$submit_action = "addmap";	
	$submit_bt_value = "CREATE MAP";
	
}
if($type == 'edit-map') {	
	  
  global $wpdb;
  global $table_name_imap;
  $mapdata = $wpdb->get_row("SELECT * FROM $table_name_imap WHERE id = $id", ARRAY_A);  	
	
	$title = "Edit Map";
	
	$message = "To add this map to your website, just use the shortcode <span id='shc'>[show-map id='".$id."']</span> on your posts, pages or widgets, or add <span id='shc'>&lt;?php build_i_world_map(".$id."); ?&gt;</span> to your template.";
	
	
	$formname = "addimap";
	$name = $mapdata['name'];
	$description = $mapdata['description'];
	$use_defaults = $mapdata['use_defaults'];
	$border_color = $mapdata['border_color'];
	$border_stroke =  $mapdata['border_stroke'];
	$bg_color = $mapdata['bg_color'];
	$ina_color = $mapdata['ina_color'];
	$act_color = $mapdata['act_color'];
	$marker_size = $mapdata['marker_size'];
	$width = $mapdata['width'];
	$height = $mapdata['height'];
	$aspect_ratio = $mapdata['aspect_ratio'];
	$interactive = $mapdata['interactive'];;
	$tooltipt = $mapdata['showtooltip'];
	$region = $mapdata['region'];
	$display_mode = $mapdata['display_mode'];
	$places = $mapdata['places'];
	$map_action = $mapdata['map_action'];
	$custom_action = $mapdata['custom_action'];
	$submit_action = "editmap";	
	$submit_bt_value = "UPDATE MAP";
	
}



?>
<div class="wrap">
<h2><img src="<?php echo plugins_url('interactive-world-maps/imgs/iwm-icon.png'); ?>" /> <?php echo $title; ?></h2>

<?php if ($alert!="") { ?>
<div id="message" class="updated"><?php echo $alert; ?></div>
<?php } ?>

<div id="iwm-message-intro"><?php echo $message; ?></div>

 
 
<form method="post" action="" id="<?php echo $formname; ?>" name="<?php echo $formname; ?>">
    
    <table width="100%" border="0" cellspacing="5" cellpadding="5">
      <tr>
        <td width="25%" valign="top"><h3>Details
        </h3>
          <table width="100%" border="0" cellspacing="2" cellpadding="2" id="add-table">
          <tr valign="top">
            <th align="left" scope="row">Name</th>
            <td><input type="text" name="name" value="<?php echo $name; ?>" /></td>
          </tr>
          <tr valign="top">
            <th align="left" scope="row">Description</th>
            <td><textarea name="description" cols="20" rows="3"><?php echo $description; ?></textarea></td>
          </tr>
         
        </table>
          <h3>Visual Settings </h3>
          <table width="100%" border="0" cellpadding="2" cellspacing="2" id="add-table">
             <tr valign="top">
            <th align="left">Visual Settings</th>
            <td><input name="use_defaults" id="use_defaults" type="radio" value="1" <?php if($use_defaults==1) { ?>checked="checked"<?php } ?> onclick="hidecustomsettings();" />
              Default
                <input name="use_defaults" id="use_defaults" type="radio" value="0" <?php if($use_defaults==0) { ?>checked="checked"<?php } ?>onclick="showcustomsettings();"/>
              Custom</td>
          </tr></table>
          <div id="default-settings-table-add" style="display:none;">
          <table>
             <th >Background Color</th>
              <td><input type="text" name="bg_color" class="color {hash:true, adjust:false}" value="<?php echo $bg_color; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <th scope="row">Border Color</th>
              <td><input type="text" name="border_color" class="color {hash:true, adjust:false}" value="<?php echo $border_color; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <th scope="row">Border Width (px)</th>
              <td><input type="text" name="border_stroke" value="<?php echo $border_stroke; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <th scope="row">Inactive Region Color</th>
              <td><input type="text" name="ina_color" class="color {hash:true, adjust:false}" value="<?php echo $ina_color; ?>"onchange="drawVisualization();" /><input type="hidden" name="act_color" class="color {hash:true, adjust:false}" value="<?php echo $act_color; ?>"onchange="drawVisualization();" /></td>
            </tr>
  
            <tr valign="top" >
              <th scope="row">Marker Size</th>
              <td><input type="text" name="marker_size" value="<?php echo $marker_size; ?>"onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top" >
              <th scope="row">Width (px)</th>
              <td><input type="text" name="width" value="<?php echo $width; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top" >
              <th scope="row">Height (px)</th>
              <td><input type="text" name="height" value="<?php echo $height; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top" >
              <th scope="row">Keep Aspect Ratio</th>
              <td><input name="aspect_ratio"  id="aspratio" type="checkbox" value="1" <?php if($aspect_ratio==1) { ?>checked <?php } ?> onchange="drawVisualization();" /></td>
            </tr>
        </table>
        
        
        </div>
        
          <p class="submit">
      <input type="submit" class="button-primary" value="<?php echo $submit_bt_value; ?>" />
  </p>
        
        </td>
        <td width="75%" valign="top"><h3>Map Settings</h3>
          <table width="100%" border="0" cellspacing="5" cellpadding="5" id="add-table">
            <tr valign="top" >
              <td><strong>Region to Display</strong></td>
              <td><strong>Display Mode</strong></td>
              <td class="totalp" ><strong>Interactivity<br />
              </strong></td>
              <td scope="row"><strong>Active Region Action </strong></td>
            </tr>
            <tr valign="top" >
              <td>
                <?php  i_world_map_build_region_select_options('region',$region,'isolinkcheck()'); ?>                <br />

             </td>
            
              <td width="33%">
                <select name="display_mode" onchange="isolinkcheck();">
                  <option value="regions"  <?php if($display_mode=='regions') { ?>selected="selected" <?php } ?> >Regions</option>
                  <option value="markers"  <?php if($display_mode=='markers') { ?>selected="selected" <?php } ?> >Markers (Text Location)</option>
                  <option value="markers02"  <?php if($display_mode=='markers02') { ?>selected="selected" <?php } ?>>Markers (Coordinates)</option>
              </select></td>
              <td nowrap="nowrap" class="totalp" >Enable
                <input name="interactive" type="checkbox"  id="interactive" onchange="drawVisualization();" value="1" <?php if($interactive==1) { ?>checked <?php } ?> />
                <br />
                Show Tooltip
  <input name="tooltipt" type="checkbox"  id="tooltipt" onchange="drawVisualization();" value="1" <?php if($tooltipt==1) { ?>checked <?php } ?> /></td>  
              <td scope="row">
				<?php i_world_map_build_actions_select_options('map_action',$map_action,'isolinkcheck()'); ?></td>
            </tr>
          </table>
          
          <span id="iso-code-msg"></span>
         
          <div id="custom-action">
          
          
          
          
          <table>
            <tr><td><strong>Insert Custom Javascript Action Here</strong><br />
            <textarea name="custom_action" cols="50" rows="4"><?php echo stripcslashes ( $custom_action); ?></textarea></td><td><span class="iwmsmall">You can use Javascript and the array ivalue_<?php if(isset($_GET['map'])) {echo $_GET['map']; } else { echo "ID"; }; ?>[selectedRegion] where variable selectedRegion is the code of the region clicked, and ivalue[selectedRegion] corresponds to the value inserted in the "Action Value" field. Example: alert(ivalue_<?php if(isset( $_GET['map'])) {echo $_GET['map'];} else { echo "ID"; }; ?>[selectedRegion]); // will display a custom alert message.</span></td></tr></table></div>
            
             <div id="latlondiv">
          <table width="100%" border="0" cellspacing="5" cellpadding="5" class="latlon">
            <tr>
              <td><strong>Use the form below to help you get the coordinates values</strong><br />Convert Address into Lat/Lon:
                <label for="mapsearch">
                  <input type="text" name="mapsearch" id="mapsearch">
                  <input type="button" name="convert" id="convert" value="Convert" onClick="getAddress()">
                </label> <span id="latlonvalues"></span></td>
              
            </tr>
          </table>
          </div>
            
            
          <h3>Interactive Regions </h3><br />



 <a class="activeb" id="shsimple" onclick="showsimple()" >Simple</a> <a class="inactiveb" id="shadvanced" onclick="showadvanced()" >Advanced</a>
			<div id="simple-table">
          <table width="100%" id="add-table">
          <tr valign="top">
            <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td>Region Code: </td>
                <td> Title: </td>
                <td>Tooltip: </td>
                <td>Action Value: </td>
                <td> Color: </td>
                <td valign="baseline"></p></td>
              </tr>
              <tr>
                <td valign="top"><input name="cd" type="text" id="cd" size="15" /><br />
 <span class="iwmsmall">Follow the suggestions <br />above.<br />
 MANDATORY
 </span></td>
                <td valign="top"><input name="c" type="text" id="c" size="15" /><br />
 <span class="iwmsmall">It will be the first line <br />of the tooltip.</span></td>
                <td valign="top"><input name="t" type="text" id="t" size="20" /><br />
 <span class="iwmsmall">It will be the second line <br />of the tooltip.</span></td>
                <td valign="top"><input name="u" type="text" id="u" size="20" />
                  <br />
                  <span class="iwmsmall">Paramater for the action. <br />
                  Ex. Url for Open Url Action. <br />
                  Simple HTML can 
                  be used.<br />
                  </span></td>
                <td valign="top"><input name="cl" type="text" id="cl" size="15" class="color {hash:true, adjust:false}" value="<?php echo $act_color; ?>"  /></td>
                <td valign="top"><input type="button" value="Add" onclick="addPlaceToTable();" /></td>
              </tr>
                     
            </table>
            
            <div id="htmlplacetable"></div>
            
            </td>
          </tr>
         
          <input name="action" type="hidden" value="<?php echo $submit_action; ?>" />
          <?php if($type == 'edit-map') { ?>
          <input name="id" type="hidden" value="<?php echo $id; ?>" />
		  <?php  } ?>
        </table>
        </div>
        <div id="advanced-table">
          <table width="100%" border="0" cellspacing="5" cellpadding="5" id="add-table-advanced">
            <tr>
              <td><strong>Advanced Data Editor</strong><br />

             <span class="iwmsmall"> Here you can add or edit the CSV (comma-separated values) data that will be parsed to build the map. <br />
It should follow this format:<br />
Region Code, Tooltip Title, Tooltip Text, Action Value, HTML Color Value;<br />
It should not use quotes. Example:<br />
US, USA, Click to visit the White House Website, http://www.whitehouse.gov/,#6699CC;<br />
PT, Portugal, Click to visit Portugal's Government Website, http://www.portugal.gov.pt/,#660000;</span>  </td>
            </tr>
            <tr>
              <td><textarea name="places" id="places" onchange="dataToTable();"><?php echo htmlspecialchars ($places); ?></textarea><br />
                <input type="button" value="Preview" onclick="dataToTable();" /></td>
            </tr>
          </table>
          </div>
<h3>Preview </h3>
<span class="iwmsmall">The 'Active Region Action' will not work on this preview. <br />
When an active region is clicked an alert message with the value inserted will display for debugging, or no alert, if no value exists. </span>
         <div id="visualization-wrap"><div id="visualization"></div></div><div id="visit">Read the <a href="<?php echo plugins_url('interactive-world-maps/documentation/index.html'); ?>" target="_blank">Documentation</a> or visit the <a href="http://cmoreira.net/interactive-world-maps-demo/" target="_blank">Plugin Demo Site</a> for more information and tips on how to use it.<br />
        
       <p>
        <span class="iwmsmall">If you want to make advanced CSS customizations to the output of your map, <a href="http://cmoreira.net/interactive-world-maps-demo/advanced-customization/" target="_blank">check this page on the official plugin website</a>.</span>
        </p>
        
        </div></td>
      </tr>
      <tr>
        <td colspan="2"></td>
      </tr>
    </table>
  

</form>
</div>
	
<?php	
}


function register_i_world_map_settings() {
	//register our settings
	register_setting( 'i-world-map-plugin-settings', 'i-world-map-settings');
}

//register default values
register_activation_hook(__FILE__, 'i_world_map_defaults');
function i_world_map_defaults() {
	$tmp = get_option('i-world-map-settings');
    if(($tmp['empty']=='1')||(!is_array($tmp))) {
		delete_option('i-world-map-settings'); 
		$arr = array(	"default_bg_color" => "#FFFFFF",
						"default_border_color" => "#CCCCCC",
						"default_border_stroke" => "0",
						"default_ina_color" => "#F5F5F5",
						"default_act_color" => "#438094",
						"default_marker_size" => "10",
						"default_width" => "600",
						"default_height" => "400",
						"default_aspect_ratio" => "1",
						"default_interactive" => "1",
						"default_showtooltip" => "1",
						"default_display_mode" => "regions",
						"default_region" => "world, countries",
						"empty" => "0",
							
		);
		update_option('i-world-map-settings', $arr);
	}
}



function i_world_map_settings_page() {
	

?>

<div class="wrap">
<h2><img src="<?php echo plugins_url('interactive-world-maps/imgs/iwm-icon.png'); ?>" /> Default Settings</h2>
<?php if($_GET['settings-updated']=="true") { 
$msg = "Settings Updated";
$type = "updated";
i_world_map_message($msg);
} ?>



  <p>
          
            Edit the default settings for the maps. <br />
            When creating a map, you can choose to use the default visual settings or create custom ones.<br />
          </p>

    <table width="100%" border="0" cellspacing="10" cellpadding="10">
      <tr>
        <td width="25%"><form method="post" action="options.php" id="dsform">
 			 <?php settings_fields( 'i-world-map-plugin-settings' ); ?>
            <?php $options = get_option('i-world-map-settings'); ?>
            <h3>
            Default Visual Settings
             </h3>
		    <table width="100%" cellpadding="2" cellspacing="2" id="default-settings-table">
            <tr valign="top">
              <td width="10%" nowrap="nowrap" scope="row"><strong>Background Color</strong></td>
              <td width="20%"><input type="text" name="i-world-map-settings[default_bg_color]" class="color {hash:true, adjust:false}" value="<?php echo $options['default_bg_color']; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <td width="10%" nowrap="nowrap" scope="row"><strong>Border Color</strong></td>
              <td width="20%"><input type="text" name="i-world-map-settings[default_border_color]" class="color {hash:true, adjust:false}" value="<?php echo $options['default_border_color']; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <td width="10%" nowrap="nowrap"><strong>Border Width (px)</strong></td>
              <td width="20%"><input name="i-world-map-settings[default_border_stroke]" value="<?php echo $options['default_border_stroke']; ?>" size="5" onchange="drawVisualization();" type="number" min="0" max="100" /></td>
            </tr>
            <tr valign="top">
              <td width="10%" nowrap="nowrap" scope="row">&nbsp;</td>
              <td width="20%">&nbsp;</td>
            </tr>
            <tr valign="top">
              <td width="10%" nowrap="nowrap" scope="row"><strong>Inactive Region Color</strong></td>
              <td width="20%"><input type="text" name="i-world-map-settings[default_ina_color]" class="color {hash:true, adjust:false}" value="<?php echo $options['default_ina_color']; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <td width="10%" nowrap="nowrap" scope="row"><strong>Active Region Color</strong></td>
              <td width="20%"><input type="text" name="i-world-map-settings[default_act_color]" class="color {hash:true, adjust:false}" value="<?php echo $options['default_act_color']; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <td nowrap="nowrap" scope="row">&nbsp;</td>
              <td>&nbsp;</td>
            </tr>
            <tr valign="top">
              <td nowrap="nowrap" scope="row"><strong>Marker Size (px)</strong></td>
              <td><input type="text" name="i-world-map-settings[default_marker_size]" value="<?php echo $options['default_marker_size']; ?>" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <td width="10%" nowrap="nowrap" scope="row">&nbsp;</td>
              <td width="20%">&nbsp;</td>
            </tr>
            <tr valign="top">
              <td width="10%" nowrap="nowrap" scope="row"><strong>Width (px)</strong></td>
              <td width="20%"><input name="i-world-map-settings[default_width]" type="text" value="<?php echo $options['default_width']; ?>" size="5" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <td width="10%" nowrap="nowrap"><strong>Height (px)</strong></td>
              <td width="20%"><input name="i-world-map-settings[default_height]" type="text" value="<?php echo $options['default_height']; ?>" size="5" onchange="drawVisualization();" /></td>
            </tr>
            <tr valign="top">
              <td width="10%" nowrap="nowrap" scope="row"><strong>Keep Aspect Ratio</strong></td>
              <td width="20%"><input name="i-world-map-settings[default_aspect_ratio]" id="aspratio" type="checkbox" value="1" <?php if($options['default_aspect_ratio']==1) { ?>checked <?php } ?> onchange="drawVisualization();" />
              
              </td>
            </tr>
            </table>
            
            <h3>Map Settings </h3>
            <p>Values will be pre-selected when creating a new map.</p>
          <table width="100%" id="default-settings-table">
            <tr valign="top">
              <td nowrap="nowrap" scope="row"><strong>Region to Show</strong><br />
                
                <?php  i_world_map_build_region_select_options('i-world-map-settings[default_region]',$options['default_region'],'drawVisualization()'); ?>              </td>
            </tr>
            <tr valign="top">
              <td scope="row">&nbsp;</td>
            </tr>
            <tr valign="top">
              <td scope="row"><strong>Display Mode</strong><br />
                <select name="i-world-map-settings[default_display_mode]" onchange="drawVisualization();">
                  <option value="regions"  <?php if($options['default_display_mode']=='regions') { ?>selected="selected" <?php } ?>>Regions</option>
                  <option value="markers"  <?php if($options['default_display_mode']=='markers') { ?>selected="selected" <?php } ?> >Markers</option>
                
              </select></td>
            </tr>
            <tr valign="top">
              <td scope="row">&nbsp;</td>
            </tr>
            <tr valign="top">
              <td scope="row"><strong>Interactivity<br />
                </strong><input name="i-world-map-settings[default_interactive]" id="interactive" type="checkbox" value="1" <?php if($options['default_interactive']==1) { ?>checked <?php } ?> onchange="drawVisualization();" />Enable<br />
                <input name="i-world-map-settings[default_showtooltip]" id="showtooltip" type="checkbox" value="1" <?php if($options['default_showtooltip']==1) { ?>checked <?php } ?> onchange="drawVisualization();" />Show Tooltip
              </td>
            </tr>
           
          </table>
          <p class="submit">
            <input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>" />
          </p>
        </form></td>
        <td width="75%" valign="top"><h3>Preview</h3>          <div id="visualization"></div>
        <div id="visit">Read the <a href="<?php echo plugins_url('interactive-world-maps/documentation/index.html'); ?>" target="_blank">Documentation</a> or visit the <a href="http://cmoreira.net/interactive-world-maps-demo/" target="_blank">Plugin Demo Site</a> for more information and tips on how to use it.</div></td>
      </tr>
    </table>
  <p>&nbsp; </p>
</div>
<?php } 


//Add Settings link to active plugins menu
add_filter('plugin_action_links', 'i_world_map_action_links', 10, 2);

function i_world_map_action_links($links, $file) {
    static $this_plugin;

    if (!$this_plugin) {
        $this_plugin = plugin_basename(__FILE__);
    }

    if ($file == $this_plugin) {
        $settings_link = '<a href="' . get_bloginfo('wpurl') . '/wp-admin/admin.php?page=iwm_settings">Settings</a>';
        array_unshift($links, $settings_link);
    }

    return $links;
}



/*************************** TABLE CLASS ********************************/
if(!class_exists('WP_List_Table')){
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class i_world_map_manage_table extends WP_List_Table {
    
     
    function __construct(){
        global $status, $page;
                
        //Set parent defaults
        parent::__construct( array(
            'singular'  => 'map',     //singular name of the listed records
            'plural'    => 'maps',    //plural name of the listed records
            'ajax'      => false        //does this table support ajax?
        ) );
        
    }
    
    
   function column_default($item, $column_name){
        switch($column_name){
            case 'shortcode':
               return "[show-map id='".$item['id']."']";
			
			case 'date':
               return $item['created'];
			   
            default:
                 return $item[$column_name]; 
        }
    }
    
        
    function column_name($item){
        
        //Build row actions
        $actions = array(
            'edit'      => sprintf('<a href="?page=iwm_add&action=%s&map=%s">Edit</a>','edit',$item['id']),
            'delete'    => sprintf('<a href="?page=%s&action=%s&map=%s">Delete</a>',$_REQUEST['page'],'delete',$item['id']),
        );
       
        //Return the title contents
        return sprintf('%1$s <span style="color:silver">(id:%2$s)</span>%3$s',
            /*$1%s*/ $item['name'],
            /*$2%s*/ $item['id'],
            /*$3%s*/ $this->row_actions($actions)
        );
    }
	
	
	      
    function column_cb($item){
        return sprintf(
            '<input type="checkbox" name="%1$s[]" value="%2$s" />',
            /*$1%s*/ $this->_args['singular'],  //Let's simply repurpose the table's singular label ("movie")

            /*$2%s*/ $item['id']                //The value of the checkbox should be the record's id
        );
    }
    
    
    function get_columns(){
        $columns = array(
            'cb'        => '<input type="checkbox" />', //Render a checkbox instead of text
			// 'id'     => 'ID',
            'name'     => 'Name',
            'description'    => 'Description',
            'shortcode'  => 'Shortcode',
			'created'  => 'Date'
        );
        return $columns;
    }
    
    function get_sortable_columns() {
        $sortable_columns = array(
            'name'    => array('name',false),
            'description'  => array('description',false),
			 'created'     => array('created',true),     //true means its already sorted

        );
        return $sortable_columns;
    }
    
    
    function get_bulk_actions() {
        $actions = array(
            'bulk-delete'    => 'Delete'
        );
        return $actions;
    }
    
    
    
    function process_bulk_action() {
        
        //Detect when a bulk action is being triggered...
       if( 'bulk-delete'===$this->current_action() ) {
           
			foreach($_GET['map'] as $map) {
			delete_i_world_map($map);	
			}
			
			$alert = "Map(s) Deleted";
			i_world_map_message($alert);
        }        
    }
    
    
    function prepare_items() {        
       
        $per_page = 5;     
        
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();     
        
        
        $this->_column_headers = array($columns, $hidden, $sortable);  
       
        $this->process_bulk_action();       
      
	    global $wpdb;
        global $table_name_imap;
		$query = "SELECT * FROM " .$table_name_imap;
		$data = $wpdb->get_results($query, ARRAY_A);      
                
        function usort_reorder($a,$b){
            $orderby = (!empty($_REQUEST['orderby'])) ? $_REQUEST['orderby'] : 'created'; //If no sort, default to title
            $order = (!empty($_REQUEST['order'])) ? $_REQUEST['order'] : 'desc'; //If no order, default to asc
            $result = strcmp($a[$orderby], $b[$orderby]); //Determine sort order
            return ($order==='asc') ? $result : -$result; //Send final sort direction to usort
        }
        usort($data, 'usort_reorder');
        
         
        $current_page = $this->get_pagenum();        
        $total_items = count($data);     
        
        $data = array_slice($data,(($current_page-1)*$per_page),$per_page);        
        
        $this->items = $data;      
        
        $this->set_pagination_args( array(
            'total_items' => $total_items,                  
            'per_page'    => $per_page,                     
            'total_pages' => ceil($total_items/$per_page)   
        ) );
    }
    
}

//Function to delete maps
function delete_i_world_map($id) {
	global $wpdb;
	global $table_name_imap;
	$wpdb->query( 
	$wpdb->prepare( 
		"
		 DELETE FROM $table_name_imap WHERE id = %d
		 ",
	     $id 
        )
);
	
	}

//To Show styled messages
function i_world_map_message($msg) { ?>
  <div id="message" class="updated"><p><?php echo $msg; ?></p></div>
<?php	
}


//Add Extra Menu to Admin Bar
function i_map_admin_bar() {
 global $wp_admin_bar;
 
 $wp_admin_bar->add_menu( array(
  'id' => 'i_world_map',
  'title' => 'i World Maps',
  'href' => admin_url('admin.php?page=i_world_map_menu')
 ) );
 
   $wp_admin_bar->add_menu( array(
  'parent' => 'i_world_map',
  'id' => 'i_world_map_manage',
  'title' => 'Manage',
  'href' => admin_url('admin.php?page=i_world_map_menu')
 ) );
 
 
  $wp_admin_bar->add_menu( array(
  'parent' => 'i_world_map',
  'id' => 'i_world_map_add',
  'title' => 'Add New',
  'href' => admin_url('admin.php?page=iwm_add')
 ) );
 
   $wp_admin_bar->add_menu( array(
  'parent' => 'i_world_map',
  'id' => 'i_world_map_default',
  'title' => 'Default Settings',
  'href' => admin_url('admin.php?page=iwm_settings')
 ) );
 
}

// If you want to add a menu to your admin bar, uncomment the line below
//add_action( 'admin_bar_menu', 'i_map_admin_bar', '61.15' );

function i_world_map_build_actions_select_options($name,$selected, $onchange) {
	
	$actions = array (
				array('name' => 'None', 'value' => 'none'),
				array('name' => 'Open URL (same window)', 'value' => 'i_map_action_open_url'),
				array('name' => 'Open URL (new window)', 'value' => 'i_map_action_open_url_new'),
				array('name' => 'Alert Message', 'value' => 'i_map_action_alert'),
				array('name' => 'Display Content Above Map', 'value' => 'i_map_action_content_above'),
				array('name' => 'Display Content Below Map', 'value' => 'i_map_action_content_below'),
				array('name' => 'Custom Action', 'value' => 'i_map_action_custom'),
	);
?>
            <select name="<?php echo $name; ?>" <?php if($onchange!="") echo 'onchange="'.$onchange.'"'; ?> >
                <?php
				foreach ($actions as $action) { ?>				
                <option value="<?php echo $action['value']; ?>" <?php if($selected==$action['value']) echo "selected='selected'"; ?> ><?php echo $action['name']; ?></option>
                <?php } ?>
                </select>
                <?php
                
                }


function i_world_map_build_region_select_options($name,$selected, $onchange) {
				$regions = array (
					array('name' => 'World', 'value' => 'world,countries'),
					array('name' => 'World - Continent Regions', 'value' => 'world,continents'),
					array('name' => 'World - Subcontinents Regions', 'value' => 'world,subcontinents'),
					array('name' => 'Africa', 'value' => '002,countries'),
					array('name' => 'Africa - Subcontinents Regions', 'value' => '002,subcontinents'),
					array('name' => 'Africa - Northern Africa', 'value' => '015,countries'),
					array('name' => 'Africa - Western Africa', 'value' => '011,countries'),
					array('name' => 'Africa - Middle Africa', 'value' => '017,countries'),
					array('name' => 'Africa - Eastern Africa', 'value' => '014,countries'),
					array('name' => 'Africa - Southern Africa', 'value' => '018,countries'),
					array('name' => 'Europe', 'value' => '150,countries'),
					array('name' => 'Europe - Subcontinents Regions', 'value' => '150,subcontinents'),
					array('name' => 'Europe - Northern Europe', 'value' => '154,countries'),
					array('name' => 'Europe - Western Europe', 'value' => '155,countries'),
					array('name' => 'Europe - Eastern Europe', 'value' => '151,countries'),
					array('name' => 'Europe - Southern Europe', 'value' => '039,countries'),
					array('name' => 'Americas', 'value' => '019,countries'),
					array('name' => 'Americas - Subcontinents Regions', 'value' => '019,subcontinents'),
					array('name' => 'Americas - Northern America', 'value' => '021,countries'),
					array('name' => 'Americas - Caribbean', 'value' => '029,countries'),
					array('name' => 'Americas - Central America', 'value' => '013,countries'),
					array('name' => 'Americas - South America', 'value' => '005,countries'),
					array('name' => 'Asia', 'value' => '142,countries'),
					array('name' => 'Asia - Subcontinents Regions', 'value' => '142,subcontinents'),					
					array('name' => 'Asia - Central Asia', 'value' => '143,countries'),
					array('name' => 'Asia - Eastern Asia', 'value' => '030,countries'),
					array('name' => 'Asia - Southern Asia', 'value' => '034,countries'),
					array('name' => 'Asia - South-Eastern Asia', 'value' => '035,countries'),
					array('name' => 'Asia - Western Asia', 'value' => '145,countries'),
					array('name' => 'Oceania', 'value' => '009,countries'),
					array('name' => 'Oceania - Subcontinents Regions', 'value' => '009,subcontinents'),
					array('name' => 'Oceania - Australia and New Zealand', 'value' => '053,countries'),
					array('name' => 'Oceania - Melanesia', 'value' => '054,countries'),
					array('name' => 'Oceania - Micronesia', 'value' => '057,countries'),
					array('name' => 'Oceania - Polynesia', 'value' => '061,countries'),
					array('name' => 'United States of America', 'value' => 'US,countries'),
					array('name' => 'United States of America - States', 'value' => 'US,provinces'),
					array('name' => 'United States of America - Metropolitan Areas', 'value' => 'US,metros'),
					array('name' => 'USA - Alabama - Metropolitan Areas', 'value' => 'US-AL,metros'),
					array('name' => 'USA - Alabama State', 'value' => 'US-AL,provinces'),
					array('name' => 'USA - Alaska - Metropolitan Areas', 'value' => 'US-AK,metros'),
					array('name' => 'USA - Alaska State', 'value' => 'US-AK,provinces'),
					array('name' => 'USA - Arizona - Metropolitan Areas', 'value' => 'US-AZ,metros'),
					array('name' => 'USA - Arizona State', 'value' => 'US-AZ,provinces'),
					array('name' => 'USA - Arkansas - Metropolitan Areas', 'value' => 'US-AR,metros'),
					array('name' => 'USA - Arkansas State', 'value' => 'US-AR,provinces'),
					array('name' => 'USA - California - Metropolitan Areas', 'value' => 'US-CA,metros'),
					array('name' => 'USA - California State', 'value' => 'US-CA,provinces'),
					array('name' => 'USA - Colorado - Metropolitan Areas', 'value' => 'US-CO,metros'),
					array('name' => 'USA - Colorado State', 'value' => 'US-CO,provinces'),
					array('name' => 'USA - Connecticut - Metropolitan Areas', 'value' => 'US-CT,metros'),
					array('name' => 'USA - Connecticut State', 'value' => 'US-CT,provinces'),
					array('name' => 'USA - Delaware - Metropolitan Areas', 'value' => 'US-DE,metros'),
					array('name' => 'USA - Delaware State', 'value' => 'US-DE,provinces'),
					array('name' => 'USA - District of Columbia - Metropolitan Areas', 'value' => 'US-DC,metros'),
					array('name' => 'USA - District of Columbia', 'value' => 'US-DC,provinces'),
					array('name' => 'USA - Florida - Metropolitan Areas', 'value' => 'US-FL,metros'),
					array('name' => 'USA - Florida State', 'value' => 'US-FL,provinces'),
					array('name' => 'USA - Georgia - Metropolitan Areas', 'value' => 'US-GA,metros'),
					array('name' => 'USA - Georgia State', 'value' => 'US-GA,provinces'),
					array('name' => 'USA - Hawaii - Metropolitan Areas', 'value' => 'US-HI,metros'),
					array('name' => 'USA - Hawaii State', 'value' => 'US-HI,provinces'),
					array('name' => 'USA - Idaho - Metropolitan Areas', 'value' => 'US-ID,metros'),
					array('name' => 'USA - Idaho State', 'value' => 'US-ID,provinces'),
					array('name' => 'USA - Illinois - Metropolitan Areas', 'value' => 'US-IL,metros'),
					array('name' => 'USA - Illinois State', 'value' => 'US-IL,provinces'),
					array('name' => 'USA - Indiana - Metropolitan Areas', 'value' => 'US-IN,metros'),
					array('name' => 'USA - Indiana State', 'value' => 'US-IN,provinces'),
					array('name' => 'USA - Iowa - Metropolitan Areas', 'value' => 'US-IA,metros'),
					array('name' => 'USA - Iowa State', 'value' => 'US-IA,provinces'),
					array('name' => 'USA - Kansas - Metropolitan Areas', 'value' => 'US-KS,metros'),
					array('name' => 'USA - Kansas State', 'value' => 'US-KS,provinces'),
					array('name' => 'USA - Kentucky - Metropolitan Areas', 'value' => 'US-KY,metros'),
					array('name' => 'USA - Kentucky State', 'value' => 'US-KY,provinces'),
					array('name' => 'USA - Louisiana - Metropolitan Areas', 'value' => 'US-LA,metros'),
					array('name' => 'USA - Louisiana State', 'value' => 'US-LA,provinces'),
					array('name' => 'USA - Maine - Metropolitan Areas', 'value' => 'US-ME,metros'),
					array('name' => 'USA - Maine State', 'value' => 'US-ME,provinces'),
					array('name' => 'USA - Maryland - Metropolitan Areas', 'value' => 'US-MD,metros'),
					array('name' => 'USA - Maryland State', 'value' => 'US-MD,provinces'),
					array('name' => 'USA - Massachusetts - Metropolitan Areas', 'value' => 'US-MA,metros'),
					array('name' => 'USA - Massachusetts State', 'value' => 'US-MA,provinces'),
					array('name' => 'USA - Michigan - Metropolitan Areas', 'value' => 'US-MI,metros'),
					array('name' => 'USA - Michigan State', 'value' => 'US-MI,provinces'),
					array('name' => 'USA - Minnesota - Metropolitan Areas', 'value' => 'US-MN,metros'),
					array('name' => 'USA - Minnesota State', 'value' => 'US-MN,provinces'),
					array('name' => 'USA - Mississippi - Metropolitan Areas', 'value' => 'US-MS,metros'),
					array('name' => 'USA - Mississippi State', 'value' => 'US-MS,provinces'),
					array('name' => 'USA - Missouri - Metropolitan Areas', 'value' => 'US-MO,metros'),
					array('name' => 'USA - Missouri State', 'value' => 'US-MO,provinces'),
					array('name' => 'USA - Montana - Metropolitan Areas', 'value' => 'US-MT,metros'),
					array('name' => 'USA - Montana State', 'value' => 'US-MT,provinces'),
					array('name' => 'USA - Nebraska - Metropolitan Areas', 'value' => 'US-NE,metros'),
					array('name' => 'USA - Nebraska State', 'value' => 'US-NE,provinces'),
					array('name' => 'USA - Nevada - Metropolitan Areas', 'value' => 'US-NV,metros'),
					array('name' => 'USA - Nevada State', 'value' => 'US-NV,provinces'),
					array('name' => 'USA - New Hampshire - Metropolitan Areas', 'value' => 'US-NH,metros'),
					array('name' => 'USA - New Hampshire State', 'value' => 'US-NH,provinces'),
					array('name' => 'USA - New Jersey - Metropolitan Areas', 'value' => 'US-NJ,metros'),
					array('name' => 'USA - New Jersey State', 'value' => 'US-NJ,provinces'),
					array('name' => 'USA - New Mexico - Metropolitan Areas', 'value' => 'US-NM,metros'),
					array('name' => 'USA - New Mexico State', 'value' => 'US-NM,provinces'),
					array('name' => 'USA - New York - Metropolitan Areas', 'value' => 'US-NY,metros'),
					array('name' => 'USA - New York State', 'value' => 'US-NY,provinces'),
					array('name' => 'USA - North Carolina - Metropolitan Areas', 'value' => 'US-NC,metros'),
					array('name' => 'USA - North Carolina State', 'value' => 'US-NC,provinces'),
					array('name' => 'USA - North Dakota - Metropolitan Areas', 'value' => 'US-ND,metros'),
					array('name' => 'USA - North Dakota State', 'value' => 'US-ND,provinces'),
					array('name' => 'USA - Ohio - Metropolitan Areas', 'value' => 'US-OH,metros'),
					array('name' => 'USA - Ohio State', 'value' => 'US-OH,provinces'),
					array('name' => 'USA - Oklahoma - Metropolitan Areas', 'value' => 'US-OK,metros'),
					array('name' => 'USA - Oklahoma State', 'value' => 'US-OK,provinces'),
					array('name' => 'USA - Oregon - Metropolitan Areas', 'value' => 'US-OR,metros'),
					array('name' => 'USA - Oregon State', 'value' => 'US-OR,provinces'),
					array('name' => 'USA - Pennsylvania - Metropolitan Areas', 'value' => 'US-PA,metros'),
					array('name' => 'USA - Pennsylvania State', 'value' => 'US-PA,provinces'),
					array('name' => 'USA - Rhode Island - Metropolitan Areas', 'value' => 'US-RI,metros'),
					array('name' => 'USA - Rhode Island State', 'value' => 'US-RI,provinces'),
					array('name' => 'USA - South Carolina - Metropolitan Areas', 'value' => 'US-SC,metros'),
					array('name' => 'USA - South Carolina State', 'value' => 'US-SC,provinces'),
					array('name' => 'USA - South Dakota - Metropolitan Areas', 'value' => 'US-SD,metros'),
					array('name' => 'USA - South Dakota State', 'value' => 'US-SD,provinces'),
					array('name' => 'USA - Tennessee - Metropolitan Areas', 'value' => 'US-TN,metros'),
					array('name' => 'USA - Tennessee State', 'value' => 'US-TN,provinces'),
					array('name' => 'USA - Texas - Metropolitan Areas', 'value' => 'US-TX,metros'),
					array('name' => 'USA - Texas State', 'value' => 'US-TX,provinces'),
					array('name' => 'USA - Utah - Metropolitan Areas', 'value' => 'US-UT,metros'),
					array('name' => 'USA - Utah State', 'value' => 'US-UT,provinces'),
					array('name' => 'USA - Vermont - Metropolitan Areas', 'value' => 'US-VT,metros'),
					array('name' => 'USA - Vermont State', 'value' => 'US-VT,provinces'),
					array('name' => 'USA - Virginia - Metropolitan Areas', 'value' => 'US-VA,metros'),
					array('name' => 'USA - Virginia State', 'value' => 'US-VA,provinces'),
					array('name' => 'USA - Washington - Metropolitan Areas', 'value' => 'US-WA,metros'),
					array('name' => 'USA - Washington State', 'value' => 'US-WA,provinces'),
					array('name' => 'USA - West Virginia - Metropolitan Areas', 'value' => 'US-WV,metros'),
					array('name' => 'USA - West Virginia State', 'value' => 'US-WV,provinces'),
					array('name' => 'USA - Wisconsin - Metropolitan Areas', 'value' => 'US-WI,metros'),
					array('name' => 'USA - Wisconsin State', 'value' => 'US-WI,provinces'),
					array('name' => 'USA - Wyoming - Metropolitan Areas', 'value' => 'US-WY,metros'),
					array('name' => 'USA - Wyoming State', 'value' => 'US-WY,provinces'),					
					array('name' => 'Afghanistan', 'value' => 'AF,countries'),
					array('name' => 'Afghanistan - Provinces', 'value' => 'AF,provinces'),
					array('name' => 'Aland Islands', 'value' => 'AX,countries'),
					array('name' => 'Aland Islands - Provinces', 'value' => 'AX,provinces'),
					array('name' => 'Albania', 'value' => 'AL,countries'),
					array('name' => 'Albania - Provinces', 'value' => 'AL,provinces'),
					array('name' => 'Algeria', 'value' => 'DZ,countries'),
					array('name' => 'Algeria - Provinces', 'value' => 'DZ,provinces'),
					array('name' => 'American Samoa', 'value' => 'AS,countries'),
					array('name' => 'American Samoa - Provinces', 'value' => 'AS,provinces'),
					array('name' => 'Andorra', 'value' => 'AD,countries'),
					array('name' => 'Andorra - Provinces', 'value' => 'AD,provinces'),
					array('name' => 'Angola', 'value' => 'AO,countries'),
					array('name' => 'Angola - Provinces', 'value' => 'AO,provinces'),
					array('name' => 'Anguilla', 'value' => 'AI,countries'),
					array('name' => 'Anguilla - Provinces', 'value' => 'AI,provinces'),
					//array('name' => 'Antarctica', 'value' => 'AQ,countries'),
					//array('name' => 'Antarctica - Provinces', 'value' => 'AQ,provinces'),
					array('name' => 'Antigua and Barbuda', 'value' => 'AG,countries'),
					array('name' => 'Antigua and Barbuda - Provinces', 'value' => 'AG,provinces'),
					array('name' => 'Argentina', 'value' => 'AR,countries'),
					array('name' => 'Argentina - Provinces', 'value' => 'AR,provinces'),
					array('name' => 'Armenia', 'value' => 'AM,countries'),
					array('name' => 'Armenia - Provinces', 'value' => 'AM,provinces'),
					array('name' => 'Aruba', 'value' => 'AW,countries'),
					array('name' => 'Aruba - Provinces', 'value' => 'AW,provinces'),
					array('name' => 'Australia', 'value' => 'AU,countries'),
					array('name' => 'Australia - Provinces', 'value' => 'AU,provinces'),
					array('name' => 'Austria', 'value' => 'AT,countries'),
					array('name' => 'Austria - Provinces', 'value' => 'AT,provinces'),
					array('name' => 'Azerbaijan', 'value' => 'AZ,countries'),
					array('name' => 'Azerbaijan - Provinces', 'value' => 'AZ,provinces'),
					array('name' => 'Bahamas', 'value' => 'BS,countries'),
					array('name' => 'Bahamas - Provinces', 'value' => 'BS,provinces'),
					array('name' => 'Bahrain', 'value' => 'BH,countries'),
					array('name' => 'Bahrain - Provinces', 'value' => 'BH,provinces'),
					array('name' => 'Bangladesh', 'value' => 'BD,countries'),
					array('name' => 'Bangladesh - Provinces', 'value' => 'BD,provinces'),
					array('name' => 'Barbados', 'value' => 'BB,countries'),
					array('name' => 'Barbados - Provinces', 'value' => 'BB,provinces'),
					array('name' => 'Belarus', 'value' => 'BY,countries'),
					array('name' => 'Belarus - Provinces', 'value' => 'BY,provinces'),
					array('name' => 'Belgium', 'value' => 'BE,countries'),
					array('name' => 'Belgium - Provinces', 'value' => 'BE,provinces'),
					array('name' => 'Belize', 'value' => 'BZ,countries'),
					array('name' => 'Belize - Provinces', 'value' => 'BZ,provinces'),
					array('name' => 'Benin', 'value' => 'BJ,countries'),
					array('name' => 'Benin - Provinces', 'value' => 'BJ,provinces'),
					array('name' => 'Bermuda', 'value' => 'BM,countries'),
					array('name' => 'Bermuda - Provinces', 'value' => 'BM,provinces'),
					array('name' => 'Bhutan', 'value' => 'BT,countries'),
					array('name' => 'Bhutan - Provinces', 'value' => 'BT,provinces'),
					array('name' => 'Bolivia, Plurinational State of', 'value' => 'BO,countries'),
					array('name' => 'Bolivia, Plurinational State of - Provinces', 'value' => 'BO,provinces'),
					array('name' => 'Bonaire, Sint Eustatius and Saba', 'value' => 'BQ,countries'),
					array('name' => 'Bonaire, Sint Eustatius and Saba - Provinces', 'value' => 'BQ,provinces'),
					array('name' => 'Bosnia and Herzegovina', 'value' => 'BA,countries'),
					array('name' => 'Bosnia and Herzegovina - Provinces', 'value' => 'BA,provinces'),
					array('name' => 'Botswana', 'value' => 'BW,countries'),
					array('name' => 'Botswana - Provinces', 'value' => 'BW,provinces'),
					array('name' => 'Bouvet Island', 'value' => 'BV,countries'),
					array('name' => 'Bouvet Island - Provinces', 'value' => 'BV,provinces'),
					array('name' => 'Brazil', 'value' => 'BR,countries'),
					array('name' => 'Brazil - Provinces', 'value' => 'BR,provinces'),
					array('name' => 'British Indian Ocean Territory', 'value' => 'IO,countries'),
					array('name' => 'British Indian Ocean Territory - Provinces', 'value' => 'IO,provinces'),
					array('name' => 'Brunei Darussalam', 'value' => 'BN,countries'),
					array('name' => 'Brunei Darussalam - Provinces', 'value' => 'BN,provinces'),
					array('name' => 'Bulgaria', 'value' => 'BG,countries'),
					array('name' => 'Bulgaria - Provinces', 'value' => 'BG,provinces'),
					array('name' => 'Burkina Faso', 'value' => 'BF,countries'),
					array('name' => 'Burkina Faso - Provinces', 'value' => 'BF,provinces'),
					array('name' => 'Burundi', 'value' => 'BI,countries'),
					array('name' => 'Burundi - Provinces', 'value' => 'BI,provinces'),
					array('name' => 'Cambodia', 'value' => 'KH,countries'),
					array('name' => 'Cambodia - Provinces', 'value' => 'KH,provinces'),
					array('name' => 'Cameroon', 'value' => 'CM,countries'),
					array('name' => 'Cameroon - Provinces', 'value' => 'CM,provinces'),
					array('name' => 'Canada', 'value' => 'CA,countries'),
					array('name' => 'Canada - Provinces', 'value' => 'CA,provinces'),
					array('name' => 'Cape Verde', 'value' => 'CV,countries'),
					array('name' => 'Cape Verde - Provinces', 'value' => 'CV,provinces'),
					array('name' => 'Cayman Islands', 'value' => 'KY,countries'),
					array('name' => 'Cayman Islands - Provinces', 'value' => 'KY,provinces'),
					array('name' => 'Central African Republic', 'value' => 'CF,countries'),
					array('name' => 'Central African Republic - Provinces', 'value' => 'CF,provinces'),
					array('name' => 'Chad', 'value' => 'TD,countries'),
					array('name' => 'Chad - Provinces', 'value' => 'TD,provinces'),
					array('name' => 'Chile', 'value' => 'CL,countries'),
					array('name' => 'Chile - Provinces', 'value' => 'CL,provinces'),
					array('name' => 'China', 'value' => 'CN,countries'),
					array('name' => 'China - Provinces', 'value' => 'CN,provinces'),
					array('name' => 'Christmas Island', 'value' => 'CX,countries'),
					array('name' => 'Christmas Island - Provinces', 'value' => 'CX,provinces'),
					array('name' => 'Cocos (Keeling) Islands', 'value' => 'CC,countries'),
					array('name' => 'Cocos (Keeling) Islands - Provinces', 'value' => 'CC,provinces'),
					array('name' => 'Colombia', 'value' => 'CO,countries'),
					array('name' => 'Colombia - Provinces', 'value' => 'CO,provinces'),
					array('name' => 'Comoros', 'value' => 'KM,countries'),
					array('name' => 'Comoros - Provinces', 'value' => 'KM,provinces'),
					array('name' => 'Congo', 'value' => 'CG,countries'),
					array('name' => 'Congo - Provinces', 'value' => 'CG,provinces'),
					array('name' => 'Congo, the Democratic Republic of the', 'value' => 'CD,countries'),
					array('name' => 'Congo, the Democratic Republic of the - Provinces', 'value' => 'CD,provinces'),
					array('name' => 'Cook Islands', 'value' => 'CK,countries'),
					array('name' => 'Cook Islands - Provinces', 'value' => 'CK,provinces'),
					array('name' => 'Costa Rica', 'value' => 'CR,countries'),
					array('name' => 'Costa Rica - Provinces', 'value' => 'CR,provinces'),
					array('name' => 'Cote d\'Ivoire ', 'value' => 'CI,countries'),
					array('name' => 'Cote d\'Ivoire  - Provinces', 'value' => 'CI,provinces'),
					array('name' => 'Croatia', 'value' => 'HR,countries'),
					array('name' => 'Croatia - Provinces', 'value' => 'HR,provinces'),
					array('name' => 'Cuba', 'value' => 'CU,countries'),
					array('name' => 'Cuba - Provinces', 'value' => 'CU,provinces'),
					array('name' => 'Curaçao', 'value' => 'CW,countries'),
					array('name' => 'Curaçao - Provinces', 'value' => 'CW,provinces'),
					array('name' => 'Cyprus', 'value' => 'CY,countries'),
					array('name' => 'Cyprus - Provinces', 'value' => 'CY,provinces'),
					array('name' => 'Czech Republic', 'value' => 'CZ,countries'),
					array('name' => 'Czech Republic - Provinces', 'value' => 'CZ,provinces'),
					array('name' => 'Denmark', 'value' => 'DK,countries'),
					array('name' => 'Denmark - Provinces', 'value' => 'DK,provinces'),
					array('name' => 'Djibouti', 'value' => 'DJ,countries'),
					array('name' => 'Djibouti - Provinces', 'value' => 'DJ,provinces'),
					array('name' => 'Dominica', 'value' => 'DM,countries'),
					array('name' => 'Dominica - Provinces', 'value' => 'DM,provinces'),
					array('name' => 'Dominican Republic', 'value' => 'DO,countries'),
					array('name' => 'Dominican Republic - Provinces', 'value' => 'DO,provinces'),
					array('name' => 'Ecuador', 'value' => 'EC,countries'),
					array('name' => 'Ecuador - Provinces', 'value' => 'EC,provinces'),
					array('name' => 'Egypt', 'value' => 'EG,countries'),
					array('name' => 'Egypt - Provinces', 'value' => 'EG,provinces'),
					array('name' => 'El Salvador', 'value' => 'SV,countries'),
					array('name' => 'El Salvador - Provinces', 'value' => 'SV,provinces'),
					array('name' => 'Equatorial Guinea', 'value' => 'GQ,countries'),
					array('name' => 'Equatorial Guinea - Provinces', 'value' => 'GQ,provinces'),
					array('name' => 'Eritrea', 'value' => 'ER,countries'),
					array('name' => 'Eritrea - Provinces', 'value' => 'ER,provinces'),
					array('name' => 'Estonia', 'value' => 'EE,countries'),
					array('name' => 'Estonia - Provinces', 'value' => 'EE,provinces'),
					array('name' => 'Ethiopia', 'value' => 'ET,countries'),
					array('name' => 'Ethiopia - Provinces', 'value' => 'ET,provinces'),
					array('name' => 'Falkland Islands (Malvinas)', 'value' => 'FK,countries'),
					array('name' => 'Falkland Islands (Malvinas) - Provinces', 'value' => 'FK,provinces'),
					array('name' => 'Faroe Islands', 'value' => 'FO,countries'),
					array('name' => 'Faroe Islands - Provinces', 'value' => 'FO,provinces'),
					array('name' => 'Fiji', 'value' => 'FJ,countries'),
					array('name' => 'Fiji - Provinces', 'value' => 'FJ,provinces'),
					array('name' => 'Finland', 'value' => 'FI,countries'),
					array('name' => 'Finland - Provinces', 'value' => 'FI,provinces'),
					array('name' => 'France', 'value' => 'FR,countries'),
					array('name' => 'France - Provinces', 'value' => 'FR,provinces'),
					array('name' => 'French Guiana', 'value' => 'GF,countries'),
					array('name' => 'French Guiana - Provinces', 'value' => 'GF,provinces'),
					array('name' => 'French Polynesia', 'value' => 'PF,countries'),
					array('name' => 'French Polynesia - Provinces', 'value' => 'PF,provinces'),
					array('name' => 'French Southern Territories', 'value' => 'TF,countries'),
					array('name' => 'French Southern Territories - Provinces', 'value' => 'TF,provinces'),
					array('name' => 'Gabon', 'value' => 'GA,countries'),
					array('name' => 'Gabon - Provinces', 'value' => 'GA,provinces'),
					array('name' => 'Gambia', 'value' => 'GM,countries'),
					array('name' => 'Gambia - Provinces', 'value' => 'GM,provinces'),
					array('name' => 'Georgia', 'value' => 'GE,countries'),
					array('name' => 'Georgia - Provinces', 'value' => 'GE,provinces'),
					array('name' => 'Germany', 'value' => 'DE,countries'),
					array('name' => 'Germany - Provinces', 'value' => 'DE,provinces'),
					array('name' => 'Ghana', 'value' => 'GH,countries'),
					array('name' => 'Ghana - Provinces', 'value' => 'GH,provinces'),
					array('name' => 'Gibraltar', 'value' => 'GI,countries'),
					array('name' => 'Gibraltar - Provinces', 'value' => 'GI,provinces'),
					array('name' => 'Greece', 'value' => 'GR,countries'),
					array('name' => 'Greece - Provinces', 'value' => 'GR,provinces'),
					array('name' => 'Greenland', 'value' => 'GL,countries'),
					array('name' => 'Greenland - Provinces', 'value' => 'GL,provinces'),
					array('name' => 'Grenada', 'value' => 'GD,countries'),
					array('name' => 'Grenada - Provinces', 'value' => 'GD,provinces'),
					array('name' => 'Guadeloupe', 'value' => 'GP,countries'),
					array('name' => 'Guadeloupe - Provinces', 'value' => 'GP,provinces'),
					array('name' => 'Guam', 'value' => 'GU,countries'),
					array('name' => 'Guam - Provinces', 'value' => 'GU,provinces'),
					array('name' => 'Guatemala', 'value' => 'GT,countries'),
					array('name' => 'Guatemala - Provinces', 'value' => 'GT,provinces'),
					array('name' => 'Guernsey', 'value' => 'GG,countries'),
					array('name' => 'Guernsey - Provinces', 'value' => 'GG,provinces'),
					array('name' => 'Guinea', 'value' => 'GN,countries'),
					array('name' => 'Guinea - Provinces', 'value' => 'GN,provinces'),
					array('name' => 'Guinea-Bissau', 'value' => 'GW,countries'),
					array('name' => 'Guinea-Bissau - Provinces', 'value' => 'GW,provinces'),
					array('name' => 'Guyana', 'value' => 'GY,countries'),
					array('name' => 'Guyana - Provinces', 'value' => 'GY,provinces'),
					array('name' => 'Haiti', 'value' => 'HT,countries'),
					array('name' => 'Haiti - Provinces', 'value' => 'HT,provinces'),
					array('name' => 'Heard Island and McDonald Islands', 'value' => 'HM,countries'),
					array('name' => 'Heard Island and McDonald Islands - Provinces', 'value' => 'HM,provinces'),
					array('name' => 'Holy See (Vatican City State)', 'value' => 'VA,countries'),
					array('name' => 'Honduras', 'value' => 'HN,countries'),
					array('name' => 'Honduras - Provinces', 'value' => 'HN,provinces'),
					array('name' => 'Hong Kong', 'value' => 'HK,countries'),
					array('name' => 'Hong Kong - Provinces', 'value' => 'HK,provinces'),
					array('name' => 'Hungary', 'value' => 'HU,countries'),
					array('name' => 'Hungary - Provinces', 'value' => 'HU,provinces'),
					array('name' => 'Iceland', 'value' => 'IS,countries'),
					array('name' => 'Iceland - Provinces', 'value' => 'IS,provinces'),
					array('name' => 'India', 'value' => 'IN,countries'),
					array('name' => 'India - Provinces', 'value' => 'IN,provinces'),
					array('name' => 'Indonesia', 'value' => 'ID,countries'),
					array('name' => 'Indonesia - Provinces', 'value' => 'ID,provinces'),
					array('name' => 'Iran, Islamic Republic of', 'value' => 'IR,countries'),
					array('name' => 'Iran, Islamic Republic of - Provinces', 'value' => 'IR,provinces'),
					array('name' => 'Iraq', 'value' => 'IQ,countries'),
					array('name' => 'Iraq - Provinces', 'value' => 'IQ,provinces'),
					array('name' => 'Ireland', 'value' => 'IE,countries'),
					array('name' => 'Ireland - Provinces', 'value' => 'IE,provinces'),
					array('name' => 'Isle of Man', 'value' => 'IM,countries'),
					array('name' => 'Isle of Man - Provinces', 'value' => 'IM,provinces'),
					array('name' => 'Israel', 'value' => 'IL,countries'),
					array('name' => 'Israel - Provinces', 'value' => 'IL,provinces'),
					array('name' => 'Italy', 'value' => 'IT,countries'),
					array('name' => 'Italy - Provinces', 'value' => 'IT,provinces'),
					array('name' => 'Jamaica', 'value' => 'JM,countries'),
					array('name' => 'Jamaica - Provinces', 'value' => 'JM,provinces'),
					array('name' => 'Japan', 'value' => 'JP,countries'),
					array('name' => 'Japan - Provinces', 'value' => 'JP,provinces'),
					array('name' => 'Jersey', 'value' => 'JE,countries'),
					array('name' => 'Jersey - Provinces', 'value' => 'JE,provinces'),
					array('name' => 'Jordan', 'value' => 'JO,countries'),
					array('name' => 'Jordan - Provinces', 'value' => 'JO,provinces'),
					array('name' => 'Kazakhstan', 'value' => 'KZ,countries'),
					array('name' => 'Kazakhstan - Provinces', 'value' => 'KZ,provinces'),
					array('name' => 'Kenya', 'value' => 'KE,countries'),
					array('name' => 'Kenya - Provinces', 'value' => 'KE,provinces'),
					array('name' => 'Kiribati', 'value' => 'KI,countries'),
					array('name' => 'Kiribati - Provinces', 'value' => 'KI,provinces'),
					array('name' => 'Korea, Democratic People\'s Republic of', 'value' => 'KP,countries'),
					array('name' => 'Korea, Democratic People\'s Republic of - Provinces', 'value' => 'KP,provinces'),
					array('name' => 'Korea, Republic of', 'value' => 'KR,countries'),
					array('name' => 'Korea, Republic of - Provinces', 'value' => 'KR,provinces'),
					array('name' => 'Kuwait', 'value' => 'KW,countries'),
					array('name' => 'Kuwait - Provinces', 'value' => 'KW,provinces'),
					array('name' => 'Kyrgyzstan', 'value' => 'KG,countries'),
					array('name' => 'Kyrgyzstan - Provinces', 'value' => 'KG,provinces'),
					array('name' => 'Lao People\'s Democratic Republic', 'value' => 'LA,countries'),
					array('name' => 'Lao People\'s Democratic Republic - Provinces', 'value' => 'LA,provinces'),
					array('name' => 'Latvia', 'value' => 'LV,countries'),
					array('name' => 'Latvia - Provinces', 'value' => 'LV,provinces'),
					array('name' => 'Lebanon', 'value' => 'LB,countries'),
					array('name' => 'Lebanon - Provinces', 'value' => 'LB,provinces'),
					array('name' => 'Lesotho', 'value' => 'LS,countries'),
					array('name' => 'Lesotho - Provinces', 'value' => 'LS,provinces'),
					array('name' => 'Liberia', 'value' => 'LR,countries'),
					array('name' => 'Liberia - Provinces', 'value' => 'LR,provinces'),
					array('name' => 'Libya', 'value' => 'LY,countries'),
					array('name' => 'Libya - Provinces', 'value' => 'LY,provinces'),
					array('name' => 'Liechtenstein', 'value' => 'LI,countries'),
					array('name' => 'Liechtenstein - Provinces', 'value' => 'LI,provinces'),
					array('name' => 'Lithuania', 'value' => 'LT,countries'),
					array('name' => 'Lithuania - Provinces', 'value' => 'LT,provinces'),
					array('name' => 'Luxembourg', 'value' => 'LU,countries'),
					array('name' => 'Luxembourg - Provinces', 'value' => 'LU,provinces'),
					array('name' => 'Macao', 'value' => 'MO,countries'),
					array('name' => 'Macao - Provinces', 'value' => 'MO,provinces'),
					array('name' => 'Macedonia, the former Yugoslav Republic of', 'value' => 'MK,countries'),
					array('name' => 'Macedonia, the former Yugoslav Republic of - Provinces', 'value' => 'MK,provinces'),
					array('name' => 'Madagascar', 'value' => 'MG,countries'),
					array('name' => 'Madagascar - Provinces', 'value' => 'MG,provinces'),
					array('name' => 'Malawi', 'value' => 'MW,countries'),
					array('name' => 'Malawi - Provinces', 'value' => 'MW,provinces'),
					array('name' => 'Malaysia', 'value' => 'MY,countries'),
					array('name' => 'Malaysia - Provinces', 'value' => 'MY,provinces'),
					array('name' => 'Maldives', 'value' => 'MV,countries'),
					array('name' => 'Maldives - Provinces', 'value' => 'MV,provinces'),
					array('name' => 'Mali', 'value' => 'ML,countries'),
					array('name' => 'Mali - Provinces', 'value' => 'ML,provinces'),
					array('name' => 'Malta', 'value' => 'MT,countries'),
					array('name' => 'Malta - Provinces', 'value' => 'MT,provinces'),
					array('name' => 'Marshall Islands', 'value' => 'MH,countries'),
					array('name' => 'Marshall Islands - Provinces', 'value' => 'MH,provinces'),
					array('name' => 'Martinique', 'value' => 'MQ,countries'),
					array('name' => 'Martinique - Provinces', 'value' => 'MQ,provinces'),
					array('name' => 'Mauritania', 'value' => 'MR,countries'),
					array('name' => 'Mauritania - Provinces', 'value' => 'MR,provinces'),
					array('name' => 'Mauritius', 'value' => 'MU,countries'),
					array('name' => 'Mauritius - Provinces', 'value' => 'MU,provinces'),
					array('name' => 'Mayotte', 'value' => 'YT,countries'),
					array('name' => 'Mayotte - Provinces', 'value' => 'YT,provinces'),
					array('name' => 'Mexico', 'value' => 'MX,countries'),
					array('name' => 'Mexico - Provinces', 'value' => 'MX,provinces'),
					array('name' => 'Micronesia, Federated States of', 'value' => 'FM,countries'),
					array('name' => 'Micronesia, Federated States of - Provinces', 'value' => 'FM,provinces'),
					array('name' => 'Moldova, Republic of', 'value' => 'MD,countries'),
					array('name' => 'Moldova, Republic of - Provinces', 'value' => 'MD,provinces'),
					array('name' => 'Monaco', 'value' => 'MC,countries'),
					array('name' => 'Monaco - Provinces', 'value' => 'MC,provinces'),
					array('name' => 'Mongolia', 'value' => 'MN,countries'),
					array('name' => 'Mongolia - Provinces', 'value' => 'MN,provinces'),
					array('name' => 'Montenegro', 'value' => 'ME,countries'),
					array('name' => 'Montenegro - Provinces', 'value' => 'ME,provinces'),
					array('name' => 'Montserrat', 'value' => 'MS,countries'),
					array('name' => 'Montserrat - Provinces', 'value' => 'MS,provinces'),
					array('name' => 'Morocco', 'value' => 'MA,countries'),
					array('name' => 'Morocco - Provinces', 'value' => 'MA,provinces'),
					array('name' => 'Mozambique', 'value' => 'MZ,countries'),
					array('name' => 'Mozambique - Provinces', 'value' => 'MZ,provinces'),
					array('name' => 'Myanmar', 'value' => 'MM,countries'),
					array('name' => 'Myanmar - Provinces', 'value' => 'MM,provinces'),
					array('name' => 'Namibia', 'value' => 'NA,countries'),
					array('name' => 'Namibia - Provinces', 'value' => 'NA,provinces'),
					array('name' => 'Nauru', 'value' => 'NR,countries'),
					array('name' => 'Nauru - Provinces', 'value' => 'NR,provinces'),
					array('name' => 'Nepal', 'value' => 'NP,countries'),
					array('name' => 'Nepal - Provinces', 'value' => 'NP,provinces'),
					array('name' => 'Netherlands', 'value' => 'NL,countries'),
					array('name' => 'Netherlands - Provinces', 'value' => 'NL,provinces'),
					array('name' => 'New Caledonia', 'value' => 'NC,countries'),
					array('name' => 'New Caledonia - Provinces', 'value' => 'NC,provinces'),
					array('name' => 'New Zealand', 'value' => 'NZ,countries'),
					array('name' => 'New Zealand - Provinces', 'value' => 'NZ,provinces'),
					array('name' => 'Nicaragua', 'value' => 'NI,countries'),
					array('name' => 'Nicaragua - Provinces', 'value' => 'NI,provinces'),
					array('name' => 'Niger', 'value' => 'NE,countries'),
					array('name' => 'Niger - Provinces', 'value' => 'NE,provinces'),
					array('name' => 'Nigeria', 'value' => 'NG,countries'),
					array('name' => 'Nigeria - Provinces', 'value' => 'NG,provinces'),
					array('name' => 'Niue', 'value' => 'NU,countries'),
					array('name' => 'Niue - Provinces', 'value' => 'NU,provinces'),
					array('name' => 'Norfolk Island', 'value' => 'NF,countries'),
					array('name' => 'Norfolk Island - Provinces', 'value' => 'NF,provinces'),
					array('name' => 'Northern Mariana Islands', 'value' => 'MP,countries'),
					array('name' => 'Northern Mariana Islands - Provinces', 'value' => 'MP,provinces'),
					array('name' => 'Norway', 'value' => 'NO,countries'),
					array('name' => 'Norway - Provinces', 'value' => 'NO,provinces'),
					array('name' => 'Oman', 'value' => 'OM,countries'),
					array('name' => 'Oman - Provinces', 'value' => 'OM,provinces'),
					array('name' => 'Pakistan', 'value' => 'PK,countries'),
					array('name' => 'Pakistan - Provinces', 'value' => 'PK,provinces'),
					array('name' => 'Palau', 'value' => 'PW,countries'),
					array('name' => 'Palau - Provinces', 'value' => 'PW,provinces'),
					array('name' => 'Palestinian Territory, Occupied', 'value' => 'PS,countries'),
					array('name' => 'Palestinian Territory, Occupied - Provinces', 'value' => 'PS,provinces'),
					array('name' => 'Panama', 'value' => 'PA,countries'),
					array('name' => 'Panama - Provinces', 'value' => 'PA,provinces'),
					array('name' => 'Papua New Guinea', 'value' => 'PG,countries'),
					array('name' => 'Papua New Guinea - Provinces', 'value' => 'PG,provinces'),
					array('name' => 'Paraguay', 'value' => 'PY,countries'),
					array('name' => 'Paraguay - Provinces', 'value' => 'PY,provinces'),
					array('name' => 'Peru', 'value' => 'PE,countries'),
					array('name' => 'Peru - Provinces', 'value' => 'PE,provinces'),
					array('name' => 'Philippines', 'value' => 'PH,countries'),
					array('name' => 'Philippines - Provinces', 'value' => 'PH,provinces'),
					array('name' => 'Pitcairn', 'value' => 'PN,countries'),
					array('name' => 'Pitcairn - Provinces', 'value' => 'PN,provinces'),
					array('name' => 'Poland', 'value' => 'PL,countries'),
					array('name' => 'Poland - Provinces', 'value' => 'PL,provinces'),
					array('name' => 'Portugal', 'value' => 'PT,countries'),
					array('name' => 'Portugal - Provinces', 'value' => 'PT,provinces'),
					array('name' => 'Puerto Rico', 'value' => 'PR,countries'),
					array('name' => 'Puerto Rico - Provinces', 'value' => 'PR,provinces'),
					array('name' => 'Qatar', 'value' => 'QA,countries'),
					array('name' => 'Qatar - Provinces', 'value' => 'QA,provinces'),
					array('name' => 'Reunion !Réunion', 'value' => 'RE,countries'),
					array('name' => 'Reunion !Réunion - Provinces', 'value' => 'RE,provinces'),
					array('name' => 'Romania', 'value' => 'RO,countries'),
					array('name' => 'Romania - Provinces', 'value' => 'RO,provinces'),
					array('name' => 'Russian Federation', 'value' => 'RU,countries'),
					array('name' => 'Russian Federation - Provinces', 'value' => 'RU,provinces'),
					array('name' => 'Rwanda', 'value' => 'RW,countries'),
					array('name' => 'Rwanda - Provinces', 'value' => 'RW,provinces'),
					array('name' => 'Saint Barthélemy', 'value' => 'BL,countries'),
					array('name' => 'Saint Barthélemy - Provinces', 'value' => 'BL,provinces'),
					array('name' => 'Saint Helena, Ascension and Tristan da Cunha', 'value' => 'SH,countries'),
					array('name' => 'Saint Helena, Ascension and Tristan da Cunha - Provinces', 'value' => 'SH,provinces'),
					array('name' => 'Saint Kitts and Nevis', 'value' => 'KN,countries'),
					array('name' => 'Saint Kitts and Nevis - Provinces', 'value' => 'KN,provinces'),
					array('name' => 'Saint Lucia', 'value' => 'LC,countries'),
					array('name' => 'Saint Lucia - Provinces', 'value' => 'LC,provinces'),
					array('name' => 'Saint Martin (French part)', 'value' => 'MF,countries'),
					array('name' => 'Saint Martin (French part) - Provinces', 'value' => 'MF,provinces'),
					array('name' => 'Saint Pierre and Miquelon', 'value' => 'PM,countries'),
					array('name' => 'Saint Pierre and Miquelon - Provinces', 'value' => 'PM,provinces'),
					array('name' => 'Saint Vincent and the Grenadines', 'value' => 'VC,countries'),
					array('name' => 'Saint Vincent and the Grenadines - Provinces', 'value' => 'VC,provinces'),
					array('name' => 'Samoa', 'value' => 'WS,countries'),
					array('name' => 'Samoa - Provinces', 'value' => 'WS,provinces'),
					array('name' => 'San Marino', 'value' => 'SM,countries'),
					array('name' => 'San Marino - Provinces', 'value' => 'SM,provinces'),
					array('name' => 'Sao Tome and Principe', 'value' => 'ST,countries'),
					array('name' => 'Sao Tome and Principe - Provinces', 'value' => 'ST,provinces'),
					array('name' => 'Saudi Arabia', 'value' => 'SA,countries'),
					array('name' => 'Saudi Arabia - Provinces', 'value' => 'SA,provinces'),
					array('name' => 'Senegal', 'value' => 'SN,countries'),
					array('name' => 'Senegal - Provinces', 'value' => 'SN,provinces'),
					array('name' => 'Serbia', 'value' => 'RS,countries'),
					array('name' => 'Serbia - Provinces', 'value' => 'RS,provinces'),
					array('name' => 'Seychelles', 'value' => 'SC,countries'),
					array('name' => 'Seychelles - Provinces', 'value' => 'SC,provinces'),
					array('name' => 'Sierra Leone', 'value' => 'SL,countries'),
					array('name' => 'Sierra Leone - Provinces', 'value' => 'SL,provinces'),
					array('name' => 'Singapore', 'value' => 'SG,countries'),
					array('name' => 'Singapore - Provinces', 'value' => 'SG,provinces'),
					array('name' => 'Sint Maarten (Dutch part)', 'value' => 'SX,countries'),
					array('name' => 'Sint Maarten (Dutch part) - Provinces', 'value' => 'SX,provinces'),
					array('name' => 'Slovakia', 'value' => 'SK,countries'),
					array('name' => 'Slovakia - Provinces', 'value' => 'SK,provinces'),
					array('name' => 'Slovenia', 'value' => 'SI,countries'),
					array('name' => 'Slovenia - Provinces', 'value' => 'SI,provinces'),
					array('name' => 'Solomon Islands', 'value' => 'SB,countries'),
					array('name' => 'Solomon Islands - Provinces', 'value' => 'SB,provinces'),
					array('name' => 'Somalia', 'value' => 'SO,countries'),
					array('name' => 'Somalia - Provinces', 'value' => 'SO,provinces'),
					array('name' => 'South Africa', 'value' => 'ZA,countries'),
					array('name' => 'South Africa - Provinces', 'value' => 'ZA,provinces'),
					array('name' => 'South Georgia and the South Sandwich Islands', 'value' => 'GS,countries'),
					array('name' => 'South Georgia and the South Sandwich Islands - Provinces', 'value' => 'GS,provinces'),
					array('name' => 'South Sudan', 'value' => 'SS,countries'),
					array('name' => 'South Sudan - Provinces', 'value' => 'SS,provinces'),
					array('name' => 'Spain', 'value' => 'ES,countries'),
					array('name' => 'Spain - Provinces', 'value' => 'ES,provinces'),
					array('name' => 'Sri Lanka', 'value' => 'LK,countries'),
					array('name' => 'Sri Lanka - Provinces', 'value' => 'LK,provinces'),
					array('name' => 'Sudan', 'value' => 'SD,countries'),
					array('name' => 'Sudan - Provinces', 'value' => 'SD,provinces'),
					array('name' => 'Suriname', 'value' => 'SR,countries'),
					array('name' => 'Suriname - Provinces', 'value' => 'SR,provinces'),
					array('name' => 'Svalbard and Jan Mayen', 'value' => 'SJ,countries'),
					array('name' => 'Svalbard and Jan Mayen - Provinces', 'value' => 'SJ,provinces'),
					array('name' => 'Swaziland', 'value' => 'SZ,countries'),
					array('name' => 'Swaziland - Provinces', 'value' => 'SZ,provinces'),
					array('name' => 'Sweden', 'value' => 'SE,countries'),
					array('name' => 'Sweden - Provinces', 'value' => 'SE,provinces'),
					array('name' => 'Switzerland', 'value' => 'CH,countries'),
					array('name' => 'Switzerland - Provinces', 'value' => 'CH,provinces'),
					array('name' => 'Syrian Arab Republic', 'value' => 'SY,countries'),
					array('name' => 'Syrian Arab Republic - Provinces', 'value' => 'SY,provinces'),
					array('name' => 'Taiwan, Province of China', 'value' => 'TW,countries'),
					array('name' => 'Taiwan, Province of China - Provinces', 'value' => 'TW,provinces'),
					array('name' => 'Tajikistan', 'value' => 'TJ,countries'),
					array('name' => 'Tajikistan - Provinces', 'value' => 'TJ,provinces'),
					array('name' => 'Tanzania, United Republic of', 'value' => 'TZ,countries'),
					array('name' => 'Tanzania, United Republic of - Provinces', 'value' => 'TZ,provinces'),
					array('name' => 'Thailand', 'value' => 'TH,countries'),
					array('name' => 'Thailand - Provinces', 'value' => 'TH,provinces'),
					array('name' => 'Timor-Leste', 'value' => 'TL,countries'),
					array('name' => 'Timor-Leste - Provinces', 'value' => 'TL,provinces'),
					array('name' => 'Togo', 'value' => 'TG,countries'),
					array('name' => 'Togo - Provinces', 'value' => 'TG,provinces'),
					array('name' => 'Tokelau', 'value' => 'TK,countries'),
					array('name' => 'Tokelau - Provinces', 'value' => 'TK,provinces'),
					array('name' => 'Tonga', 'value' => 'TO,countries'),
					array('name' => 'Tonga - Provinces', 'value' => 'TO,provinces'),
					array('name' => 'Trinidad and Tobago', 'value' => 'TT,countries'),
					array('name' => 'Trinidad and Tobago - Provinces', 'value' => 'TT,provinces'),
					array('name' => 'Tunisia', 'value' => 'TN,countries'),
					array('name' => 'Tunisia - Provinces', 'value' => 'TN,provinces'),
					array('name' => 'Turkey', 'value' => 'TR,countries'),
					array('name' => 'Turkey - Provinces', 'value' => 'TR,provinces'),
					array('name' => 'Turkmenistan', 'value' => 'TM,countries'),
					array('name' => 'Turkmenistan - Provinces', 'value' => 'TM,provinces'),
					array('name' => 'Turks and Caicos Islands', 'value' => 'TC,countries'),
					array('name' => 'Turks and Caicos Islands - Provinces', 'value' => 'TC,provinces'),
					array('name' => 'Tuvalu', 'value' => 'TV,countries'),
					array('name' => 'Tuvalu - Provinces', 'value' => 'TV,provinces'),
					array('name' => 'Uganda', 'value' => 'UG,countries'),
					array('name' => 'Uganda - Provinces', 'value' => 'UG,provinces'),
					array('name' => 'Ukraine', 'value' => 'UA,countries'),
					array('name' => 'Ukraine - Provinces', 'value' => 'UA,provinces'),
					array('name' => 'United Arab Emirates', 'value' => 'AE,countries'),
					array('name' => 'United Arab Emirates - Provinces', 'value' => 'AE,provinces'),
					array('name' => 'United Kingdom', 'value' => 'GB,countries'),
					array('name' => 'United Kingdom - Provinces', 'value' => 'GB,provinces'),
					array('name' => 'United States', 'value' => 'US,countries'),
					array('name' => 'United States - Provinces', 'value' => 'US,provinces'),
					array('name' => 'United States Minor Outlying Islands', 'value' => 'UM,countries'),
					array('name' => 'United States Minor Outlying Islands - Provinces', 'value' => 'UM,provinces'),
					array('name' => 'Uruguay', 'value' => 'UY,countries'),
					array('name' => 'Uruguay - Provinces', 'value' => 'UY,provinces'),
					array('name' => 'Uzbekistan', 'value' => 'UZ,countries'),
					array('name' => 'Uzbekistan - Provinces', 'value' => 'UZ,provinces'),
					array('name' => 'Vanuatu', 'value' => 'VU,countries'),
					array('name' => 'Vanuatu - Provinces', 'value' => 'VU,provinces'),
					array('name' => 'Venezuela, Bolivarian Republic of', 'value' => 'VE,countries'),
					array('name' => 'Venezuela, Bolivarian Republic of - Provinces', 'value' => 'VE,provinces'),
					array('name' => 'Viet Nam', 'value' => 'VN,countries'),
					array('name' => 'Viet Nam - Provinces', 'value' => 'VN,provinces'),
					array('name' => 'Virgin Islands, British', 'value' => 'VG,countries'),
					array('name' => 'Virgin Islands, British - Provinces', 'value' => 'VG,provinces'),
					array('name' => 'Virgin Islands, U.S.', 'value' => 'VI,countries'),
					array('name' => 'Virgin Islands, U.S. - Provinces', 'value' => 'VI,provinces'),
					array('name' => 'Wallis and Futuna', 'value' => 'WF,countries'),
					array('name' => 'Wallis and Futuna - Provinces', 'value' => 'WF,provinces'),
					array('name' => 'Western Sahara', 'value' => 'EH,countries'),
					array('name' => 'Western Sahara - Provinces', 'value' => 'EH,provinces'),
					array('name' => 'Yemen', 'value' => 'YE,countries'),
					array('name' => 'Yemen - Provinces', 'value' => 'YE,provinces'),
					array('name' => 'Zambia', 'value' => 'ZM,countries'),
					array('name' => 'Zambia - Provinces', 'value' => 'ZM,provinces'),
					array('name' => 'Zimbabwe', 'value' => 'ZW,countries'),
					array('name' => 'Zimbabwe - Provinces', 'value' => 'ZW,provinces'),


					
				); ?>
                <select name="<?php echo $name; ?>" id="<?php echo $name; ?>" <?php if($onchange!="") echo 'onchange="'.$onchange.'"'; ?> >
                <?php
				foreach ($regions as $region) { ?>				
                <option value="<?php echo $region['value']; ?>" <?php if($selected==$region['value']) echo "selected='selected'"; ?> ><?php echo $region['name']; ?></option>
                <?php } ?>
                </select>
                <?php
                
                }



function i_world_map_run_action($action, $id,$custom_action) { ?>

	google.visualization.events.addListener(geochart, 'select', function() {
	var selection = geochart.getSelection();
	
    	if (selection.length == 1) {
			var selectedRow = selection[0].row;
            var selectedRegion = data.getValue(selectedRow, 0);

	<?php 
		if($action == 'i_map_action_open_url') {	
		echo 'if(ivalue_'.$id.'[selectedRegion].length >= 1) { 
				document.location = ivalue_'.$id.'[selectedRegion]; 
				}';
		}
		
		if($action == 'i_map_action_alert') {
		echo 'if(ivalue_'.$id.'[selectedRegion] != "") { 
			alert(ivalue_'.$id.'[selectedRegion]); 
			}';
		}
		
		if($action == 'i_map_action_open_url_new') {
		echo 'if(ivalue_'.$id.'[selectedRegion].length >= 1) { 
				window.open(ivalue_'.$id.'[selectedRegion]); 
				}';
		}
		
		if($action == 'i_map_action_content_below') {
		echo "document.getElementById('imap".$id."message').innerHTML = ivalue_".$id."[selectedRegion];";
		}
		
		if($action == 'i_map_action_content_above') {
		echo "document.getElementById('imap".$id."message').innerHTML = ivalue_".$id."[selectedRegion];";
		}
		
		
		if($action == 'i_map_action_custom') {
		echo stripcslashes ( $custom_action );
		}
		
	
	?>
            }
      });
    <?php
 }


?>